/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.block.DimensionalPortalBlock;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.client.ToolTipHelper;
import org.dimdev.dimdoors.item.ModItems;
import org.dimdev.dimdoors.item.RaycastHelper;
import org.jetbrains.annotations.Nullable;

public class RiftBladeItem
extends SwordItem {
    public static final String ID = "rift_blade";

    public RiftBladeItem(Item.Properties settings) {
        super((Tier)Tiers.IRON, 3, -2.4f, settings);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        ToolTipHelper.processTranslation(list, this.m_5524_() + ".info", new Object[0]);
    }

    public boolean m_5812_(ItemStack itemStack) {
        return true;
    }

    public boolean m_6832_(ItemStack item, ItemStack repairingItem) {
        return Objects.equals(ModItems.STABLE_FABRIC.get(), repairingItem.m_41720_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        HitResult hit = RaycastHelper.raycast((Entity)player, 16.0, 0.0f, LivingEntity.class::isInstance);
        if (hit == null) {
            hit = RaycastHelper.raycast((Entity)player, 16.0, 1.0f, LivingEntity.class::isInstance);
        }
        if (hit == null) {
            hit = player.m_19907_(16.0, 1.0f, false);
        }
        if (hit == null) {
            hit = player.m_19907_(16.0, 0.0f, false);
        }
        if (world.f_46443_) {
            if (RaycastHelper.hitsLivingEntity(hit) || RaycastHelper.hitsRift(hit, (BlockGetter)world)) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".rift_miss")), true);
            RiftBlockEntity.showRiftCoreUntil = System.currentTimeMillis() + (long)DimensionalDoors.getConfig().getGraphicsConfig().highlightRiftCoreFor;
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (RaycastHelper.hitsLivingEntity(hit)) {
            double damageMultiplier = (double)stack.m_41773_() / (double)stack.m_41776_();
            double offsetDistance = Math.random() * damageMultiplier * 7.0 + 2.0;
            double offsetRotationYaw = (Math.random() - 0.5) * damageMultiplier * 360.0;
            Vec3 playerVec = player.m_20182_();
            Vec3 entityVec = hit.m_82450_();
            Vec3 offsetDirection = playerVec.m_82546_(entityVec).m_82541_();
            offsetDirection = offsetDirection.m_82524_((float)(offsetRotationYaw * Math.PI) / 180.0f);
            Vec3 added = entityVec.m_82549_(offsetDirection.m_82490_(offsetDistance));
            BlockPos teleportPosition = new BlockPos(new Vec3i((int)added.f_82479_, (int)added.f_82480_, (int)added.f_82481_));
            while (world.m_8055_(teleportPosition).m_60767_().m_76334_()) {
                teleportPosition = teleportPosition.m_7494_();
            }
            player.m_6021_((double)teleportPosition.m_123341_(), (double)teleportPosition.m_123342_(), (double)teleportPosition.m_123343_());
            player.m_146922_((float)(Math.random() * 2.0 * Math.PI));
            stack.m_41622_(1, (LivingEntity)player, a -> a.m_21190_(hand));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (RaycastHelper.hitsDetachedRift(hit, (BlockGetter)world)) {
            BlockHitResult blockHitResult = (BlockHitResult)hit;
            BlockPos pos = blockHitResult.m_82425_();
            RiftBlockEntity rift = (RiftBlockEntity)world.m_7702_(blockHitResult.m_82425_());
            world.m_46597_(pos, (BlockState)((Block)ModBlocks.DIMENSIONAL_PORTAL.get()).m_49966_().m_61124_((Property)DimensionalPortalBlock.FACING, (Comparable)blockHitResult.m_82434_()));
            ((EntranceRiftBlockEntity)world.m_7702_(pos)).setData(rift.getData());
            stack.m_41622_(1, (LivingEntity)player, a -> a.m_21190_(hand));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }
}

