/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.RotatedLocation;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.client.ToolTipHelper;
import org.dimdev.dimdoors.rift.targets.RiftReference;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.dimdev.dimdoors.world.ModDimensions;

public class RiftSignatureItem
extends Item {
    public static final String ID = "rift_signature";

    public RiftSignatureItem(Item.Properties settings) {
        super(settings);
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128441_("destination");
    }

    public InteractionResult m_6225_(UseOnContext itemUsageContext) {
        Player player = itemUsageContext.m_43723_();
        Level world = itemUsageContext.m_43725_();
        BlockPos pos = itemUsageContext.m_8083_();
        InteractionHand hand = itemUsageContext.m_43724_();
        Direction side = itemUsageContext.m_43719_();
        BlockPlaceContext placementContext = new BlockPlaceContext(itemUsageContext);
        ItemStack stack = player.m_21120_(hand);
        BlockPos blockPos = pos = world.m_8055_(pos).m_60734_().m_6864_(world.m_8055_(pos), placementContext) ? pos : pos.m_121945_(side);
        if (!player.m_36204_(pos, side.m_122424_(), stack)) {
            return InteractionResult.FAIL;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (ModDimensions.isPrivatePocketDimension(world) && !DimensionalDoors.getConfig().getPocketsConfig().canUseRiftSignatureInPrivatePockets) {
            player.m_5661_((Component)Component.m_237115_((String)"tools.signature_blocked").m_130940_(ChatFormatting.BLACK), true);
            return InteractionResult.FAIL;
        }
        RotatedLocation target = RiftSignatureItem.getSource(stack);
        if (target == null) {
            RiftSignatureItem.setSource(stack, new RotatedLocation((ResourceKey<Level>)world.m_46472_(), pos, player.m_146908_(), 0.0f));
            player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".stored")), true);
            world.m_5594_(null, player.m_20183_(), (SoundEvent)ModSoundEvents.RIFT_START.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
        } else {
            if (target.getBlockState().m_60734_() != ModBlocks.DETACHED_RIFT) {
                if (!target.getBlockState().m_60734_().m_5568_()) {
                    player.m_5661_((Component)Component.m_237115_((String)"tools.target_became_block"), true);
                    RiftSignatureItem.clearSource(stack);
                    return InteractionResult.FAIL;
                }
                ServerLevel sourceWorld = DimensionalDoors.getWorld((ResourceKey<Level>)target.world);
                sourceWorld.m_46597_(target.getBlockPos(), ((Block)ModBlocks.DETACHED_RIFT.get()).m_49966_());
                DetachedRiftBlockEntity rift1 = (DetachedRiftBlockEntity)target.getBlockEntity();
                rift1.setDestination(RiftReference.tryMakeRelative(target, new Location((ServerLevel)world, pos)));
                rift1.register();
            }
            world.m_46597_(pos, ((Block)ModBlocks.DETACHED_RIFT.get()).m_49966_());
            DetachedRiftBlockEntity rift2 = (DetachedRiftBlockEntity)world.m_7702_(pos);
            rift2.setDestination(RiftReference.tryMakeRelative(new Location((ServerLevel)world, pos), target));
            rift2.register();
            stack.m_41622_(1, (LivingEntity)player, a -> {});
            RiftSignatureItem.clearSource(stack);
            player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".created")), true);
            world.m_5594_(null, player.m_20183_(), (SoundEvent)ModSoundEvents.RIFT_END.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public static void setSource(ItemStack itemStack, RotatedLocation destination) {
        if (!itemStack.m_41782_()) {
            itemStack.m_41751_(new CompoundTag());
        }
        itemStack.m_41783_().m_128365_("destination", (Tag)RotatedLocation.serialize(destination));
    }

    public static void clearSource(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            itemStack.m_41783_().m_128473_("destination");
        }
    }

    public static RotatedLocation getSource(ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("destination")) {
            return RotatedLocation.deserialize(itemStack.m_41783_().m_128469_("destination"));
        }
        return null;
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag tooltipContext) {
        RotatedLocation transform = RiftSignatureItem.getSource(itemStack);
        if (transform != null) {
            list.add((Component)Component.m_237110_((String)(this.m_5524_() + ".bound.info0"), (Object[])new Object[]{transform.getX(), transform.getY(), transform.getZ(), transform.getWorldId().m_135782_()}));
            list.add((Component)Component.m_237110_((String)(this.m_5524_() + ".bound.info1"), (Object[])new Object[]{transform.getWorldId().m_135782_()}));
        } else {
            ToolTipHelper.processTranslation(list, this.m_5524_() + ".unbound.info", new Object[0]);
        }
    }
}

