/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.RotatedLocation;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.rift.targets.RiftReference;
import org.dimdev.dimdoors.sound.ModSoundEvents;

public class StabilizedRiftSignatureItem
extends Item {
    public static final String ID = "stabilized_rift_signature";

    public StabilizedRiftSignatureItem(Item.Properties settings) {
        super(settings);
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128441_("destination");
    }

    public InteractionResult m_6225_(UseOnContext itemUsageContext) {
        Player player = itemUsageContext.m_43723_();
        Level world = itemUsageContext.m_43725_();
        BlockPos pos = itemUsageContext.m_8083_();
        InteractionHand hand = itemUsageContext.m_43724_();
        Direction side = itemUsageContext.m_43719_();
        BlockPlaceContext itemPlacementContext = new BlockPlaceContext(itemUsageContext);
        ItemStack stack = player.m_21120_(hand);
        BlockPos blockPos = pos = world.m_8055_(pos).m_60734_().m_6864_(world.m_8055_(pos), new BlockPlaceContext(itemUsageContext)) ? pos : pos.m_121945_(side);
        if (!player.m_36204_(pos, side.m_122424_(), stack)) {
            return InteractionResult.FAIL;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        RotatedLocation target = StabilizedRiftSignatureItem.getTarget(stack);
        if (target == null) {
            StabilizedRiftSignatureItem.setSource(stack, new RotatedLocation((ResourceKey<Level>)world.m_46472_(), pos, player.m_146908_(), 0.0f));
            player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".stored")), true);
            world.m_5594_(null, player.m_20183_(), (SoundEvent)ModSoundEvents.RIFT_START.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
        } else {
            if (target.getBlockState().m_60734_() != ModBlocks.DETACHED_RIFT) {
                if (!target.getBlockState().m_60734_().m_6864_(world.m_8055_(target.getBlockPos()), itemPlacementContext)) {
                    player.m_5661_((Component)Component.m_237115_((String)"tools.target_became_block"), true);
                    return InteractionResult.FAIL;
                }
                ServerLevel targetWorld = DimensionalDoors.getWorld((ResourceKey<Level>)target.world);
                targetWorld.m_46597_(target.getBlockPos(), ((Block)ModBlocks.DETACHED_RIFT.get()).m_49966_());
                DetachedRiftBlockEntity rift1 = (DetachedRiftBlockEntity)target.getBlockEntity();
                rift1.register();
            }
            world.m_46597_(pos, ((Block)ModBlocks.DETACHED_RIFT.get()).m_49966_());
            DetachedRiftBlockEntity rift2 = (DetachedRiftBlockEntity)world.m_7702_(pos);
            rift2.setDestination(RiftReference.tryMakeRelative(new Location((ServerLevel)world, pos), target));
            rift2.register();
            stack.m_41622_(1, (LivingEntity)player, playerEntity -> {});
            player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".created")), true);
            world.m_5594_(null, player.m_20183_(), (SoundEvent)ModSoundEvents.RIFT_END.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public static void setSource(ItemStack itemStack, RotatedLocation destination) {
        if (!itemStack.m_41782_()) {
            itemStack.m_41751_(new CompoundTag());
        }
        itemStack.m_41783_().m_128365_("destination", (Tag)RotatedLocation.serialize(destination));
    }

    public static void clearSource(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            itemStack.m_41783_().m_128473_("destination");
        }
    }

    public static RotatedLocation getTarget(ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("destination")) {
            return RotatedLocation.deserialize(itemStack.m_41783_().m_128469_("destination"));
        }
        return null;
    }
}

