/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item.door;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.RiftProvider;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.client.ToolTipHelper;
import org.jetbrains.annotations.Nullable;

public class DimensionalDoorItem
extends BlockItem {
    private final Consumer<? super EntranceRiftBlockEntity> setupFunction;
    private boolean hasToolTip = false;

    public DimensionalDoorItem(Block block, Item.Properties settings, Consumer<? super EntranceRiftBlockEntity> setupFunction) {
        this(block, settings, setupFunction, false);
    }

    public DimensionalDoorItem(Block block, Item.Properties settings, Consumer<? super EntranceRiftBlockEntity> setupFunction, boolean hasToolTip) {
        super(block, settings);
        this.setupFunction = setupFunction;
        this.hasToolTip = hasToolTip;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> list, TooltipFlag tooltipContext) {
        if (this.hasToolTip) {
            ToolTipHelper.processTranslation(list, this.m_5524_() + ".info", new Object[0]);
        }
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        InteractionResult result;
        boolean placedOnRift;
        BlockPos pos = context.m_8083_();
        if (!context.m_43725_().m_8055_(pos).m_60629_(context)) {
            pos = pos.m_121945_(context.m_7820_());
        }
        boolean bl = placedOnRift = context.m_43725_().m_8055_(pos).m_60734_() == ModBlocks.DETACHED_RIFT.get();
        if (!placedOnRift && !context.m_43723_().m_6144_() && DimensionalDoorItem.isRiftNear(context.m_43725_(), pos)) {
            if (context.m_43725_().f_46443_) {
                context.m_43723_().m_5661_((Component)Component.m_237115_((String)"rifts.entrances.rift_too_close"), true);
                RiftBlockEntity.showRiftCoreUntil = System.currentTimeMillis() + (long)DimensionalDoors.getConfig().getGraphicsConfig().highlightRiftCoreFor;
            }
            return InteractionResult.FAIL;
        }
        if (context.m_43725_().f_46443_) {
            return super.m_40576_(context);
        }
        DetachedRiftBlockEntity rift = null;
        if (placedOnRift) {
            rift = (DetachedRiftBlockEntity)context.m_43725_().m_7702_(pos);
            rift.setUnregisterDisabled(true);
        }
        if ((result = super.m_40576_(context)) == InteractionResult.SUCCESS || result == InteractionResult.CONSUME) {
            BlockState state = context.m_43725_().m_8055_(pos);
            if (rift == null) {
                EntranceRiftBlockEntity entranceRift = (EntranceRiftBlockEntity)((RiftProvider)state.m_60734_()).getRift(context.m_43725_(), pos, state);
                this.setupRift(entranceRift);
                entranceRift.m_6596_();
                entranceRift.register();
            } else {
                EntranceRiftBlockEntity newRift = (EntranceRiftBlockEntity)context.m_43725_().m_7702_(pos);
                newRift.copyFrom(rift);
                newRift.updateType();
            }
        } else if (rift != null) {
            rift.setUnregisterDisabled(false);
        }
        return result;
    }

    public static boolean isRiftNear(Level world, BlockPos pos) {
        for (int x = pos.m_123341_() - 5; x < pos.m_123341_() + 5; ++x) {
            for (int y = pos.m_123342_() - 5; y < pos.m_123342_() + 5; ++y) {
                for (int z = pos.m_123343_() - 5; z < pos.m_123343_() + 5; ++z) {
                    BlockPos searchPos = new BlockPos(x, y, z);
                    if (world.m_8055_(searchPos).m_60734_() != ModBlocks.DETACHED_RIFT.get()) continue;
                    DetachedRiftBlockEntity rift = (DetachedRiftBlockEntity)world.m_7702_(searchPos);
                    if (!(Math.sqrt(pos.m_123331_((Vec3i)searchPos)) < (double)rift.size)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setupRift(EntranceRiftBlockEntity entranceRift) {
        this.setupFunction.accept(entranceRift);
    }
}

