/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item.door;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.utils.Env;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.function.TriFunction;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlock;
import org.dimdev.dimdoors.block.door.DimensionalTrapdoorBlock;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.client.UnderlaidChildItemRenderer;
import org.dimdev.dimdoors.item.ItemExtensions;
import org.dimdev.dimdoors.item.ModItems;
import org.dimdev.dimdoors.item.door.DimensionalDoorItem;
import org.dimdev.dimdoors.item.door.DimensionalTrapdoorItem;
import org.dimdev.dimdoors.item.door.DoorRiftDataLoader;
import org.dimdev.dimdoors.item.door.data.RiftDataList;
import org.dimdev.dimdoors.rift.targets.EscapeTarget;
import org.dimdev.dimdoors.rift.targets.PublicPocketTarget;
import org.joml.Quaternionf;

public class DimensionalDoorItemRegistrar {
    public static final String PREFIX = "item_ag_dim_";
    private final Registrar<Item> registry;
    private final Map<Block, Block> blocksAlreadyNotifiedAbout = new HashMap<Block, Block>();
    private final Map<Block, Triple<ResourceLocation, Item, Function<Block, BlockItem>>> toBeMapped = new HashMap<Block, Triple<ResourceLocation, Item, Function<Block, BlockItem>>>();
    private final Map<Item, Function<BlockPlaceContext, InteractionResult>> placementFunctions = new HashMap<Item, Function<BlockPlaceContext, InteractionResult>>();

    public DimensionalDoorItemRegistrar() {
        this.registry = RegistrarManager.get((String)"dimdoors").get(Registries.f_256913_);
        if (Platform.isFabric()) {
            this.init();
        }
        RegistrarManager.get((String)"dimdoors").forRegistry(Registries.f_256913_, registrar -> new ArrayList<Map.Entry>(registrar.entrySet()).forEach(entry -> this.handleEntry((Registrar<Item>)registrar, ((ResourceKey)entry.getKey()).m_135782_(), (Item)entry.getValue())));
    }

    public boolean isRegistered(Item item) {
        return this.placementFunctions.containsKey(item);
    }

    public InteractionResult place(Item item, BlockPlaceContext context) {
        return this.placementFunctions.get(item).apply(context);
    }

    private void init() {
        new ArrayList<Map.Entry>(this.registry.entrySet()).forEach(entry -> this.handleEntry(this.registry, ((ResourceKey)entry.getKey()).m_135782_(), (Item)entry.getValue()));
    }

    public void handleEntry(Registrar<Item> registrar, ResourceLocation identifier, Item original) {
        if (DimensionalDoors.getConfig().getDoorsConfig().isAllowed(identifier)) {
            Block originalBlock;
            if (original instanceof DoubleHighBlockItem) {
                DoubleHighBlockItem doubleHighBlockItem = (DoubleHighBlockItem)original;
                Block block = doubleHighBlockItem.m_40614_();
                this.handleEntry(registrar, identifier, original, block, AutoGenDimensionalDoorItem::new);
            } else if (original instanceof BlockItem && (originalBlock = ((BlockItem)original).m_40614_()) instanceof DoorBlock) {
                this.handleEntry(registrar, identifier, original, originalBlock, AutoGenDimensionalDoorItem::new);
            }
        }
    }

    private void handleEntry(Registrar<Item> registrar, ResourceLocation identifier, Item original, Block originalBlock, TriFunction<Block, Item.Properties, Item, ? extends BlockItem> constructor) {
        if (!(originalBlock instanceof DimensionalDoorBlock) && !(originalBlock instanceof DimensionalTrapdoorBlock) && (originalBlock instanceof DoorBlock || originalBlock instanceof TrapDoorBlock)) {
            Item.Properties settings = ItemExtensions.getSettings(original).arch$tab(ModItems.DIMENSIONAL_DOORS);
            Function<Block, BlockItem> dimItemConstructor = dimBlock -> (BlockItem)constructor.apply((Block)dimBlock, settings, original);
            if (!this.blocksAlreadyNotifiedAbout.containsKey(originalBlock)) {
                this.toBeMapped.put(originalBlock, (Triple<ResourceLocation, Item, Function<Block, BlockItem>>)new ImmutableTriple((Object)identifier, (Object)original, dimItemConstructor));
                return;
            }
            this.register(registrar, identifier, original, this.blocksAlreadyNotifiedAbout.get(originalBlock), dimItemConstructor);
        }
    }

    public void notifyBlockMapped(Block original, Block dimBlock) {
        if (!this.toBeMapped.containsKey(original)) {
            this.blocksAlreadyNotifiedAbout.put(original, dimBlock);
            return;
        }
        Triple<ResourceLocation, Item, Function<Block, BlockItem>> triple = this.toBeMapped.get(original);
        this.register(this.registry, (ResourceLocation)triple.getLeft(), (Item)triple.getMiddle(), dimBlock, (Function)triple.getRight());
    }

    private void register(Registrar<Item> registrar, ResourceLocation identifier, Item original, Block block, Function<Block, BlockItem> dimItem) {
        ResourceLocation gennedId = DimensionalDoors.id(PREFIX + identifier.m_135827_() + "_" + identifier.m_135815_());
        BlockItem item = (BlockItem)registrar.register(gennedId, () -> (BlockItem)dimItem.apply(block)).get();
        this.placementFunctions.put(original, arg_0 -> ((BlockItem)item).m_40576_(arg_0));
        if (Platform.getEnvironment() == Env.CLIENT) {
            this.registerItemRenderer(item);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemRenderer(BlockItem dimItem) {
    }

    public static interface ChildItem {
        public Item getOriginalItem();

        default public void transform(PoseStack matrices) {
        }
    }

    private static class AutoGenDimensionalTrapdoorItem
    extends DimensionalTrapdoorItem
    implements ChildItem {
        private final Item originalItem;

        public AutoGenDimensionalTrapdoorItem(Block block, Item.Properties settings, Item originalItem) {
            super(block, settings, null);
            this.originalItem = originalItem;
        }

        @Override
        protected void setupRift(EntranceRiftBlockEntity entranceRift) {
            RiftDataList data = DoorRiftDataLoader.getInstance().getRiftData(this.originalItem);
            if (data != null) {
                RiftDataList.OptRiftData riftData = data.getRiftData(entranceRift);
                entranceRift.setDestination(riftData.getDestination());
                riftData.getProperties().ifPresent(entranceRift::setProperties);
            } else {
                entranceRift.setDestination(new EscapeTarget(true));
            }
        }

        public MutableComponent getName(ItemStack stack) {
            return Component.m_237110_((String)"dimdoors.autogen_item_prefix", (Object[])new Object[]{I18n.m_118938_((String)this.originalItem.m_5524_(), (Object[])new Object[0])});
        }

        @Override
        public Item getOriginalItem() {
            return this.originalItem;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void transform(PoseStack matrices) {
            matrices.m_85841_(0.55f, 0.55f, 0.6f);
            matrices.m_85837_(0.05, -0.05, 0.41);
            matrices.m_252781_(new Quaternionf().rotateXYZ(90.0f, 0.0f, 0.0f));
        }
    }

    private static class AutoGenDimensionalDoorItem
    extends DimensionalDoorItem
    implements ChildItem {
        private final Item originalItem;

        public AutoGenDimensionalDoorItem(Block block, Item.Properties settings, Item originalItem) {
            super(block, settings, null);
            this.originalItem = originalItem;
        }

        @Override
        public void setupRift(EntranceRiftBlockEntity entranceRift) {
            RiftDataList data = DoorRiftDataLoader.getInstance().getRiftData(this.originalItem);
            if (data != null) {
                RiftDataList.OptRiftData riftData = data.getRiftData(entranceRift);
                entranceRift.setDestination(riftData.getDestination());
                riftData.getProperties().ifPresent(entranceRift::setProperties);
            } else {
                entranceRift.setDestination(new PublicPocketTarget());
            }
        }

        public MutableComponent getName(ItemStack stack) {
            return Component.m_237110_((String)"dimdoors.autogen_item_prefix", (Object[])new Object[]{I18n.m_118938_((String)this.originalItem.m_5524_(), (Object[])new Object[0])});
        }

        @Override
        public Item getOriginalItem() {
            return this.originalItem;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void transform(PoseStack matrices) {
            matrices.m_85841_(0.769f, 0.769f, 1.0f);
            matrices.m_85837_(-0.06, 0.125, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static interface Renderer {
        public static final UnderlaidChildItemRenderer RENDERER = new UnderlaidChildItemRenderer(Items.f_42584_);
    }
}

