/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item.door;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.item.door.data.RiftDataList;

public final class DoorRiftDataLoader
implements ResourceManagerReloadListener {
    private static final DoorRiftDataLoader INSTANCE = new DoorRiftDataLoader();
    private static final Logger LOGGER = LogManager.getLogger((String)"DoorRiftDataLoader");
    private static final Gson GSON = new GsonBuilder().create();
    private final Map<Item, RiftDataList> itemRiftData = new HashMap<Item, RiftDataList>();

    public static DoorRiftDataLoader getInstance() {
        return INSTANCE;
    }

    private DoorRiftDataLoader() {
    }

    public RiftDataList getRiftData(Item item) {
        return this.itemRiftData.get(item);
    }

    public void m_6213_(ResourceManager manager) {
        this.itemRiftData.clear();
        Map resources = manager.m_214159_("door/data", id -> id.m_135815_().endsWith(".json"));
        resources.forEach((id, resource) -> {
            String name = id.m_135815_().substring(id.m_135815_().lastIndexOf(47) + 1, id.m_135815_().lastIndexOf(46));
            ResourceLocation itemId = new ResourceLocation(id.m_135827_(), name);
            if (!BuiltInRegistries.f_257033_.m_7804_(itemId)) {
                LOGGER.error("Could not find item " + itemId + " for door data " + id);
                return;
            }
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
            try {
                JsonArray json = (JsonArray)GSON.fromJson((Reader)resource.m_215508_(), JsonArray.class);
                RiftDataList dataList = RiftDataList.fromJson(json);
                this.itemRiftData.put(item, dataList);
            }
            catch (IOException e) {
                LOGGER.error("Could not read door data " + id, (Throwable)e);
            }
        });
    }
}

