/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.listener.pocket;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.api.util.math.GridUtil;
import org.dimdev.dimdoors.network.client.ClientPacketHandler;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class PocketListenerUtil {
    public static <T> List<T> applicableAddons(Class<T> clazz, Level world, BlockPos pos) {
        if (world.f_46443_) {
            throw new UnsupportedOperationException("Cannot call this method on the Client.");
        }
        if (!ModDimensions.isPocketDimension(world)) {
            return Collections.emptyList();
        }
        Pocket pocket = DimensionalRegistry.getPocketDirectory((ResourceKey<Level>)world.m_46472_()).getPocketAt(pos);
        if (pocket == null) {
            return Collections.emptyList();
        }
        return pocket.getAddonsInstanceOf(clazz);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T> List<T> applicableAddonsClient(Class<T> clazz, Level world, BlockPos pos) {
        ClientPacketHandler packetHandler = ClientPacketHandler.getHandler();
        if (!world.m_46472_().equals(packetHandler.getPocketWorld())) {
            return Collections.emptyList();
        }
        int pocketId = GridUtil.gridPosToID(new GridUtil.GridPos(pos, packetHandler.getGridSize()));
        if (pocketId < packetHandler.getPocketId() || pocketId >= packetHandler.getPocketId() + packetHandler.getPocketRange()) {
            return Collections.emptyList();
        }
        return packetHandler.getAddons().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }
}

