/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.mixin;

import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.mixin.accessor.EntityAccessor;
import org.dimdev.dimdoors.world.ModDimensions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class}, priority=900)
public abstract class PlayerEntityMixin
extends LivingEntity {
    @Shadow
    public abstract void m_36220_(ResourceLocation var1);

    public PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void handleLimboFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (ModDimensions.isLimboDimension(this.f_19853_)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkDeath(DamageSource source, CallbackInfo ci) {
        this.doOnDeathStuff(source, ci);
    }

    @Unique
    protected void doOnDeathStuff(DamageSource source, CallbackInfo ci) {
        if (ModDimensions.isPocketDimension(this.f_19853_) || DimensionalDoors.getConfig().getLimboConfig().shouldUseLimbo((ResourceKey<Level>)this.f_19853_.m_46472_())) {
            ((EntityAccessor)((Object)this)).setRemovalReason(null);
            this.f_20890_ = false;
            this.m_21153_(this.m_21233_());
            ci.cancel();
        }
    }
}

