/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.network;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.item.ExtendedItem;
import org.dimdev.dimdoors.network.ExtendedServerPlayNetworkHandler;
import org.dimdev.dimdoors.network.ServerPacketListener;
import org.dimdev.dimdoors.network.packet.c2s.HitBlockWithItemC2SPacket;
import org.dimdev.dimdoors.network.packet.c2s.NetworkHandlerInitializedC2SPacket;
import org.dimdev.dimdoors.network.packet.s2c.PlayerInventorySlotUpdateS2CPacket;
import org.dimdev.dimdoors.network.packet.s2c.SyncPocketAddonsS2CPacket;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.PocketDirectory;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.addon.AutoSyncedAddon;

public class ServerPacketHandler
implements ServerPacketListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServerGamePacketListenerImpl networkHandler;
    private final Set<ResourceLocation> registeredChannels = new HashSet<ResourceLocation>();
    private boolean initialized = false;
    private ResourceKey<Level> lastSyncedPocketWorld;
    private int lastSyncedPocketId = Integer.MIN_VALUE;
    private boolean pocketSyncDirty = true;

    public static void init() {
        DimensionalDoors.NETWORK.register(NetworkHandlerInitializedC2SPacket.class, NetworkHandlerInitializedC2SPacket::write, NetworkHandlerInitializedC2SPacket::new, NetworkHandlerInitializedC2SPacket::apply);
        DimensionalDoors.NETWORK.register(HitBlockWithItemC2SPacket.class, HitBlockWithItemC2SPacket::write, HitBlockWithItemC2SPacket::new, HitBlockWithItemC2SPacket::apply);
    }

    public static ServerPacketHandler get(ServerPlayer player) {
        return ServerPacketHandler.get(player.f_8906_);
    }

    public static ServerPacketHandler get(ServerGamePacketListenerImpl networkHandler) {
        return ((ExtendedServerPlayNetworkHandler)networkHandler).getDimDoorsPacketHandler();
    }

    public static <T> boolean sendPacket(ServerPlayer player, T packet) {
        try {
            DimensionalDoors.NETWORK.sendToPlayer(player, packet);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return false;
        }
    }

    public <T> boolean sendPacket(T packet) {
        return ServerPacketHandler.sendPacket(this.getPlayer(), packet);
    }

    public ServerPacketHandler(ServerGamePacketListenerImpl networkHandler) {
        this.networkHandler = networkHandler;
    }

    private void unregisterReceiver(ResourceLocation channelName) {
        this.registeredChannels.remove(channelName);
    }

    public void unregister() {
        new HashSet<ResourceLocation>(this.registeredChannels).forEach(this::unregisterReceiver);
    }

    public MinecraftServer getServer() {
        return ((ExtendedServerPlayNetworkHandler)this.networkHandler).dimdoorsGetServer();
    }

    public ServerPlayer getPlayer() {
        return this.networkHandler.f_9743_;
    }

    public void syncPocketAddonsIfNeeded(Level world, BlockPos pos) {
        if (!ModDimensions.isPocketDimension(world)) {
            return;
        }
        PocketDirectory directory = DimensionalRegistry.getPocketDirectory((ResourceKey<Level>)world.m_46472_());
        Pocket pocket = directory.getPocketAt(pos);
        if (pocket == null) {
            return;
        }
        if (this.pocketSyncDirty || pocket.getId() != this.lastSyncedPocketId || !world.m_46472_().m_135782_().equals((Object)this.lastSyncedPocketWorld.m_135782_())) {
            this.pocketSyncDirty = false;
            this.lastSyncedPocketId = pocket.getId();
            this.lastSyncedPocketWorld = world.m_46472_();
            ServerPacketHandler.sendPacket(this.getPlayer(), new SyncPocketAddonsS2CPacket((ResourceKey<Level>)world.m_46472_(), directory.getGridSize(), pocket.getId(), pocket.getRange(), pocket.getAddonsInstanceOf(AutoSyncedAddon.class)));
        }
    }

    public void markPocketSyncDirty(int id) {
        if (this.lastSyncedPocketId == id) {
            this.pocketSyncDirty = true;
        }
    }

    public void sync(ItemStack stack, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            this.sendPacket(new PlayerInventorySlotUpdateS2CPacket(45, stack));
        } else {
            this.sendPacket(new PlayerInventorySlotUpdateS2CPacket(this.getPlayer().m_150109_().f_35977_, stack));
        }
    }

    @Override
    public void onAttackBlock(HitBlockWithItemC2SPacket packet) {
        this.getServer().execute(() -> {
            Item item = this.getPlayer().m_21120_(packet.getHand()).m_41720_();
            if (item instanceof ExtendedItem) {
                ((ExtendedItem)item).onAttackBlock(this.getPlayer().f_19853_, (Player)this.getPlayer(), packet.getHand(), packet.getPos(), packet.getDirection());
            }
        });
    }

    @Override
    public void onNetworkHandlerInitialized(NetworkHandlerInitializedC2SPacket packet) {
        this.syncPocketAddonsIfNeeded(this.getPlayer().f_19853_, this.getPlayer().m_20183_());
    }
}

