/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.network.packet.s2c;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.network.client.ClientPacketHandler;

public class MonolithAggroParticlesPacket {
    public static final ResourceLocation ID = DimensionalDoors.id("monolith_aggro_particles");
    @OnlyIn(value=Dist.CLIENT)
    private static final RandomSource clientRandom = RandomSource.m_216327_();
    private int aggro;

    @OnlyIn(value=Dist.CLIENT)
    public MonolithAggroParticlesPacket() {
    }

    public MonolithAggroParticlesPacket(int aggro) {
        this.aggro = aggro;
    }

    public MonolithAggroParticlesPacket(FriendlyByteBuf buf) {
        this(buf.m_130242_());
    }

    public FriendlyByteBuf write(FriendlyByteBuf buf) {
        buf.m_130130_(this.aggro);
        return buf;
    }

    public void apply(Supplier<NetworkManager.PacketContext> context) {
        ClientPacketHandler.getHandler().onMonolithAggroParticles(this);
    }

    public int getAggro() {
        return this.aggro;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(int aggro) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (aggro < 120) {
            return;
        }
        int count = 10 * aggro / 250;
        for (int i = 1; i < count; ++i) {
            player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, player.m_20185_() + (clientRandom.m_188500_() - 0.5) * 3.0, player.m_20186_() + clientRandom.m_188500_() * (double)player.m_20206_() - 0.75, player.m_20189_() + (clientRandom.m_188500_() - 0.5) * (double)player.m_20205_(), (clientRandom.m_188500_() - 0.5) * 2.0, -clientRandom.m_188500_(), (clientRandom.m_188500_() - 0.5) * 2.0);
        }
    }
}

