/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.NbtUtil;
import org.dimdev.dimdoors.api.util.Path;
import org.dimdev.dimdoors.api.util.ResourceUtil;
import org.dimdev.dimdoors.api.util.SimpleTree;
import org.dimdev.dimdoors.api.util.WeightedList;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.PocketTemplate;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.pockets.virtual.VirtualPocket;
import org.dimdev.dimdoors.util.schematic.Schematic;

public class PocketLoader
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final PocketLoader INSTANCE = new PocketLoader();
    private SimpleTree<String, PocketGenerator> pocketGenerators = new SimpleTree(String.class);
    private SimpleTree<String, VirtualPocket> pocketGroups = new SimpleTree(String.class);
    private SimpleTree<String, VirtualPocket> virtualPockets = new SimpleTree(String.class);
    private SimpleTree<String, PocketTemplate> templates = new SimpleTree(String.class);
    private SimpleTree<String, Tag> dataTree = new SimpleTree(String.class);

    private PocketLoader() {
    }

    public void dump() {
        this.virtualPockets.forEach((path, pocketGenerator) -> LOGGER.info("Virtual Pocket: " + path + " -> " + pocketGenerator.toString()));
        this.pocketGroups.forEach((path, pocketGenerator) -> LOGGER.info("Pocket Group: " + path + " -> " + pocketGenerator.toString()));
    }

    public void m_6213_(ResourceManager manager) {
        this.pocketGenerators.clear();
        this.pocketGroups.clear();
        this.virtualPockets.clear();
        this.templates.clear();
        this.dataTree.clear();
        this.dataTree = ResourceUtil.loadResourcePathToMap(manager, "pockets/json", ".json", new SimpleTree(String.class), ResourceUtil.NBT_READER.composeIdentity(), ResourceUtil.PATH_KEY_PROVIDER).join();
        CompletableFuture futurePocketGeneratorMap = ResourceUtil.loadResourcePathToMap(manager, "pockets/generators", ".json", new SimpleTree(String.class), ResourceUtil.NBT_READER.andThenReader(this.pocketGeneratorLoader(manager)), ResourceUtil.PATH_KEY_PROVIDER);
        CompletableFuture futurePocketGroups = ResourceUtil.loadResourcePathToMap(manager, "pockets/groups", ".json", new SimpleTree(String.class), ResourceUtil.NBT_READER.andThenReader(this.virtualPocketLoader(manager)), ResourceUtil.PATH_KEY_PROVIDER);
        CompletableFuture futureVirtualPockets = ResourceUtil.loadResourcePathToMap(manager, "pockets/virtual", ".json", new SimpleTree(String.class), ResourceUtil.NBT_READER.andThenReader(this.virtualPocketLoader(manager)), ResourceUtil.PATH_KEY_PROVIDER);
        CompletableFuture futureTemplates = ResourceUtil.loadResourcePathToMap(manager, "pockets/schematic", ".schem", new SimpleTree(String.class), ResourceUtil.COMPRESSED_NBT_READER.andThenReader(this::loadPocketTemplate), ResourceUtil.PATH_KEY_PROVIDER);
        this.pocketGenerators = futurePocketGeneratorMap.join();
        this.pocketGroups = futurePocketGroups.join();
        this.virtualPockets = futureVirtualPockets.join();
        this.templates = futureTemplates.join();
        this.pocketGroups.values().forEach(VirtualPocket::init);
        this.virtualPockets.values().forEach(VirtualPocket::init);
    }

    public Tag getDataNbt(String id) {
        return this.dataTree.get(Path.stringPath(id));
    }

    public CompoundTag getDataNbtCompound(String id) {
        return NbtUtil.asNbtCompound(this.getDataNbt(id), "Could not convert Tag \"" + id + "\" to CompoundTag!");
    }

    private BiFunction<Tag, Path<String>, VirtualPocket> virtualPocketLoader(ResourceManager manager) {
        return (nbt, ignore) -> VirtualPocket.deserialize(nbt, manager);
    }

    private BiFunction<Tag, Path<String>, PocketGenerator> pocketGeneratorLoader(ResourceManager manager) {
        return (nbt, ignore) -> PocketGenerator.deserialize(NbtUtil.asNbtCompound(nbt, "Could not load PocketGenerator since its json does not represent an CompoundTag!"), manager);
    }

    private PocketTemplate loadPocketTemplate(CompoundTag nbt, Path<String> id) {
        try {
            return new PocketTemplate(Schematic.fromNbt(nbt), new ResourceLocation(id.reduce(String::concat).orElseThrow()));
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading " + nbt.toString(), e);
        }
    }

    public WeightedList<PocketGenerator, PocketGenerationContext> getPocketsMatchingTags(List<String> required, List<String> blackList, boolean exact) {
        return new WeightedList<PocketGenerator, PocketGenerationContext>(this.pocketGenerators.values().stream().filter(pocketGenerator -> pocketGenerator.checkTags(required, blackList, exact)).collect(Collectors.toList()));
    }

    public VirtualPocket getGroup(ResourceLocation group) {
        return this.pocketGroups.get(Path.stringPath(group));
    }

    public static PocketLoader getInstance() {
        return INSTANCE;
    }

    public SimpleTree<String, PocketTemplate> getTemplates() {
        return this.templates;
    }

    public SimpleTree<String, VirtualPocket> getPocketGroups() {
        return this.pocketGroups;
    }

    public SimpleTree<String, VirtualPocket> getVirtualPockets() {
        return this.virtualPockets;
    }

    public PocketGenerator getGenerator(ResourceLocation id) {
        return this.pocketGenerators.get(Path.stringPath(id));
    }
}

