/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.rift.targets.PocketEntranceMarker;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.VirtualLocation;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class ChunkGenerator
extends PocketGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY = "chunk";
    private ResourceLocation dimensionID;
    private Vec3i size;
    private int virtualYOffset;

    @Override
    public PocketGenerator fromNbt(CompoundTag nbt, ResourceManager manager) {
        super.fromNbt(nbt, manager);
        this.dimensionID = new ResourceLocation(nbt.m_128461_("dimension_id"));
        int[] temp = nbt.m_128465_("size");
        this.size = new Vec3i(temp[0], temp[1], temp[2]);
        this.virtualYOffset = nbt.m_128441_("virtual_y_offset") ? nbt.m_128451_("virtual_y_offset") : 0;
        return this;
    }

    @Override
    public CompoundTag toNbtInternal(CompoundTag nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        nbt.m_128359_("dimension_id", this.dimensionID.toString());
        nbt.m_128385_("size", new int[]{this.size.m_123341_(), this.size.m_123342_(), this.size.m_123343_()});
        nbt.m_128405_("virtual_y_offset", this.virtualYOffset);
        return nbt;
    }

    @Override
    public Pocket prepareAndPlacePocket(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
        ServerLevel world = parameters.world();
        VirtualLocation sourceVirtualLocation = parameters.sourceVirtualLocation();
        int chunkSizeX = (this.size.m_123341_() >> 4) + (this.size.m_123341_() % 16 == 0 ? 0 : 1);
        int chunkSizeZ = (this.size.m_123343_() >> 4) + (this.size.m_123343_() % 16 == 0 ? 0 : 1);
        Object pocket = DimensionalRegistry.getPocketDirectory((ResourceKey<Level>)world.m_46472_()).newPocket(builder);
        LOGGER.info("Generating chunk pocket at location " + ((Pocket)pocket).getOrigin());
        ServerLevel genWorld = DimensionalDoors.getWorld((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)this.dimensionID));
        net.minecraft.world.level.chunk.ChunkGenerator genWorldChunkGenerator = genWorld.m_7726_().m_8481_();
        RandomState config = RandomState.m_255302_((NoiseGeneratorSettings)NoiseGeneratorSettings.m_238396_(), (HolderGetter)world.m_9598_().m_175515_(Registries.f_256865_).m_255303_(), (long)world.m_7328_());
        ArrayList<ChunkAccess> protoChunks = new ArrayList<ChunkAccess>();
        for (int z = 0; z < chunkSizeZ; ++z) {
            for (int x = 0; x < chunkSizeX; ++x) {
                ChunkAccess protoChunk = new ProtoChunk(new ChunkPos(((Pocket)pocket).getOrigin().m_7918_(x * 16, 0, z * 16)), UpgradeData.f_63320_, (LevelHeightAccessor)world, genWorld.m_9598_().m_175515_(Registries.f_256952_), null);
                protoChunk.m_63209_(genWorld.m_5518_());
                protoChunks.add(protoChunk);
            }
        }
        ChunkRegionHack protoRegion = new ChunkRegionHack(genWorld, protoChunks);
        for (ChunkAccess protoChunk : protoChunks) {
            genWorldChunkGenerator.m_255037_(genWorld.m_9598_(), genWorld.m_7726_().m_255415_(), genWorld.m_215010_(), protoChunk, genWorld.m_215082_());
            ((ProtoChunk)protoChunk).m_7150_(ChunkStatus.f_62315_);
        }
        for (ChunkAccess protoChunk : protoChunks) {
            genWorldChunkGenerator.m_223076_((WorldGenLevel)protoRegion, genWorld.m_215010_().m_220468_((WorldGenRegion)protoRegion), protoChunk);
            ((ProtoChunk)protoChunk).m_7150_(ChunkStatus.f_62316_);
        }
        for (ChunkAccess protoChunk : protoChunks) {
            genWorldChunkGenerator.m_213908_((Executor)Util.m_183991_(), config, Blender.m_190153_(), genWorld.m_215010_(), protoChunk);
            ((ProtoChunk)protoChunk).m_7150_(ChunkStatus.f_62317_);
        }
        for (ChunkAccess protoChunk : protoChunks) {
            try {
                genWorldChunkGenerator.m_213974_((Executor)Util.m_183991_(), Blender.m_190153_(), config, genWorld.m_215010_().m_220468_((WorldGenRegion)protoRegion), protoChunk).get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            ((ProtoChunk)protoChunk).m_7150_(ChunkStatus.f_62318_);
        }
        for (ChunkAccess protoChunk : protoChunks) {
            genWorldChunkGenerator.m_214194_((WorldGenRegion)protoRegion, genWorld.m_215010_(), config, protoChunk);
            ((ProtoChunk)protoChunk).m_7150_(ChunkStatus.f_62319_);
        }
        for (GenerationStep.Carving carver : GenerationStep.Carving.values()) {
            for (ChunkAccess protoChunk : protoChunks) {
                genWorldChunkGenerator.m_213679_((WorldGenRegion)protoRegion, genWorld.m_7328_(), config, genWorld.m_7062_(), genWorld.m_215010_(), protoChunk, carver);
                ProtoChunk pChunk = (ProtoChunk)protoChunk;
                if (pChunk.m_6415_() == ChunkStatus.f_62319_) {
                    pChunk.m_7150_(ChunkStatus.f_62320_);
                    continue;
                }
                pChunk.m_7150_(ChunkStatus.f_62321_);
            }
        }
        for (ChunkAccess protoChunk : protoChunks) {
            ChunkRegionHack tempRegion = new ChunkRegionHack(genWorld, ChunkPos.m_45596_((ChunkPos)protoChunk.m_7697_(), (int)10).map(chunkPos -> protoRegion.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_)).collect(Collectors.toList()));
            genWorldChunkGenerator.m_213609_((WorldGenLevel)tempRegion, protoChunk, genWorld.m_215010_().m_220468_((WorldGenRegion)tempRegion));
            ((ProtoChunk)protoChunk).m_7150_(ChunkStatus.f_62322_);
        }
        for (ChunkAccess protoChunk : protoChunks) {
            ((ThreadedLevelLightEngine)genWorld.m_5518_()).m_9353_(protoChunk, false);
            ((ProtoChunk)protoChunk).m_7150_(ChunkStatus.f_62323_);
        }
        for (ChunkAccess protoChunk : protoChunks) {
            ChunkRegionHack tempRegion = new ChunkRegionHack(genWorld, ChunkPos.m_45596_((ChunkPos)protoChunk.m_7697_(), (int)5).map(chunkPos -> protoRegion.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_)).collect(Collectors.toList()));
            genWorldChunkGenerator.m_6929_((WorldGenRegion)tempRegion);
            ((ProtoChunk)protoChunk).m_7150_(ChunkStatus.f_62324_);
        }
        BlockPos firstCorner = ((Pocket)pocket).getOrigin();
        BlockPos secondCorner = new BlockPos(firstCorner.m_123341_() + this.size.m_123341_() - 1, Math.min(firstCorner.m_123342_() + this.size.m_123342_() - 1, world.m_141928_() - this.virtualYOffset - 1), firstCorner.m_123343_() + this.size.m_123343_() - 1);
        BlockPos pocketOriginChunkOffset = new ChunkPos(((Pocket)pocket).getOrigin()).m_45615_().m_121996_((Vec3i)firstCorner);
        for (Object blockPos : BlockPos.m_121940_((BlockPos)firstCorner, (BlockPos)secondCorner)) {
            BlockPos sourcePos = blockPos.m_121955_((Vec3i)pocketOriginChunkOffset).m_7918_(0, this.virtualYOffset, 0);
            BlockState blockState = protoRegion.m_8055_(sourcePos);
            if (blockState.m_60795_()) continue;
            world.m_46597_((BlockPos)blockPos, protoRegion.m_8055_(blockPos.m_121955_((Vec3i)pocketOriginChunkOffset).m_7918_(0, this.virtualYOffset, 0)));
        }
        AABB realBox = new AABB(firstCorner, secondCorner);
        for (ChunkAccess protoChunk : protoChunks) {
            for (BlockPos virtualBlockPos : protoChunk.m_5928_()) {
                BlockPos realBlockPos = virtualBlockPos.m_121996_((Vec3i)pocketOriginChunkOffset).m_7918_(0, -this.virtualYOffset, 0);
                if (!realBox.m_82393_((double)realBlockPos.m_123341_(), (double)realBlockPos.m_123342_(), (double)realBlockPos.m_123343_())) continue;
                world.m_151523_(protoChunk.m_7702_(virtualBlockPos));
            }
        }
        AABB virtualBox = realBox.m_82338_(pocketOriginChunkOffset.m_7918_(0, this.virtualYOffset, 0));
        world.m_46597_(world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ((Pocket)pocket).getOrigin()), ((Block)ModBlocks.DETACHED_RIFT.get()).m_49966_());
        DetachedRiftBlockEntity rift = (DetachedRiftBlockEntity)((BlockEntityType)ModBlockEntityTypes.DETACHED_RIFT.get()).m_155264_(world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ((Pocket)pocket).getOrigin()), ((Block)ModBlocks.DETACHED_RIFT.get()).m_49966_());
        world.m_151523_((BlockEntity)rift);
        rift.setDestination(new PocketEntranceMarker());
        ((Pocket)pocket).virtualLocation = sourceVirtualLocation;
        return pocket;
    }

    @Override
    public PocketGenerator.PocketGeneratorType<? extends PocketGenerator> getType() {
        return (PocketGenerator.PocketGeneratorType)PocketGenerator.PocketGeneratorType.CHUNK.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public Vec3i getSize(PocketGenerationContext parameters) {
        return this.size;
    }

    private static class ChunkRegionHack
    extends WorldGenRegion {
        ChunkRegionHack(ServerLevel world, List<ChunkAccess> chunks) {
            super(world, chunks, ChunkStatus.f_62314_, 0);
        }

        public ChunkAccess m_6522_(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
            ChunkAccess chunk = super.m_6522_(chunkX, chunkZ, leastStatus, false);
            return chunk == null ? new ProtoChunkHack(new ChunkPos(chunkX, chunkZ), UpgradeData.f_63320_, (LevelHeightAccessor)this, (Registry<Biome>)this.m_9598_().m_175515_(Registries.f_256952_)) : chunk;
        }
    }

    private static class ProtoChunkHack
    extends ProtoChunk {
        public ProtoChunkHack(ChunkPos pos, UpgradeData upgradeData, LevelHeightAccessor world, Registry<Biome> biomeRegistry) {
            super(pos, upgradeData, world, biomeRegistry, null);
        }

        public BlockState m_6978_(BlockPos pos, BlockState state, boolean moved) {
            return Blocks.f_50626_.m_49966_();
        }

        public BlockState m_8055_(BlockPos pos) {
            return Blocks.f_50626_.m_49966_();
        }

        public FluidState m_6425_(BlockPos pos) {
            return Fluids.f_76191_.m_76145_();
        }
    }
}

