/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.virtual;

import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.packs.resources.ResourceManager;
import org.dimdev.dimdoors.api.util.ResourceUtil;
import org.dimdev.dimdoors.api.util.WeightedList;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.virtual.VirtualPocket;
import org.dimdev.dimdoors.pockets.virtual.reference.PocketGeneratorReference;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.jetbrains.annotations.Nullable;

public class VirtualPocketList
extends WeightedList<VirtualPocket, PocketGenerationContext>
implements VirtualPocket {
    private String resourceKey = null;

    public static VirtualPocketList deserialize(Tag nbt, @Nullable ResourceManager manager) {
        return switch (nbt.m_7060_()) {
            case 9 -> VirtualPocketList.deserialize((ListTag)nbt, manager);
            case 8 -> ResourceUtil.loadReferencedResource(manager, "pockets/virtual", nbt.m_7916_(), ResourceUtil.NBT_READER.andThenComposable(nbtElement -> VirtualPocketList.deserialize(nbtElement, manager)));
            default -> throw new RuntimeException(String.format("Unexpected NbtType %d!", nbt.m_7060_()));
        };
    }

    public static VirtualPocketList deserialize(Tag nbt) {
        return VirtualPocketList.deserialize(nbt, null);
    }

    public static VirtualPocketList deserialize(ListTag nbt, @Nullable ResourceManager manager) {
        return new VirtualPocketList().fromNbt(nbt, manager);
    }

    public static VirtualPocketList deserialize(ListTag nbt) {
        return VirtualPocketList.deserialize(nbt, null);
    }

    @Override
    public void setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    @Override
    public String getResourceKey() {
        return this.resourceKey;
    }

    public static Tag serialize(VirtualPocketList virtualPocketList, boolean allowReference) {
        return virtualPocketList.toNbt(new ListTag(), allowReference);
    }

    public static Tag serialize(VirtualPocketList virtualPocket) {
        return VirtualPocketList.serialize(virtualPocket, false);
    }

    public VirtualPocketList fromNbt(ListTag nbt, ResourceManager manager) {
        for (Tag value : nbt) {
            this.add(VirtualPocket.deserialize(value, manager));
        }
        return this;
    }

    public VirtualPocketList fromNbt(ListTag nbt) {
        return this.fromNbt(nbt, null);
    }

    public Tag toNbt(ListTag nbt, boolean allowReference) {
        if (allowReference && this.resourceKey != null) {
            return StringTag.m_129297_((String)this.resourceKey);
        }
        for (VirtualPocket virtualPocket : this) {
            nbt.add((Object)VirtualPocket.serialize(virtualPocket, allowReference));
        }
        return nbt;
    }

    public Tag toNbt(ListTag nbt) {
        return this.toNbt(nbt, false);
    }

    @Override
    public Pocket prepareAndPlacePocket(PocketGenerationContext context) {
        return this.getNextPocketGeneratorReference(context).prepareAndPlacePocket(context);
    }

    @Override
    public PocketGeneratorReference getNextPocketGeneratorReference(PocketGenerationContext context) {
        return ((VirtualPocket)this.getNextRandomWeighted(context)).getNextPocketGeneratorReference(context);
    }

    @Override
    public PocketGeneratorReference peekNextPocketGeneratorReference(PocketGenerationContext context) {
        return ((VirtualPocket)this.peekNextRandomWeighted(context)).peekNextPocketGeneratorReference(context);
    }

    @Override
    public void init() {
        this.forEach(VirtualPocket::init);
    }

    @Override
    public double getWeight(PocketGenerationContext context) {
        return this.getTotalWeight(context);
    }
}

