/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.dimdev.dimdoors.recipe.ModRecipeSerializers;
import org.dimdev.dimdoors.recipe.ModRecipeTypes;

public class TesselatingRecipe
implements Recipe<Container> {
    private final int width;
    final int height;
    final NonNullList<Ingredient> recipeItems;
    final ItemStack result;
    private final ResourceLocation id;
    final String group;
    final boolean showNotification;
    private final float experience;
    private final int weavingTime;

    public TesselatingRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result, float experience, int weavingTime, boolean showNotification) {
        this.id = id;
        this.group = group;
        this.width = width;
        this.height = height;
        this.recipeItems = recipeItems;
        this.result = result;
        this.experience = experience;
        this.weavingTime = weavingTime;
        this.showNotification = showNotification;
    }

    public TesselatingRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result, float experience, int weavingTime) {
        this(id, group, width, height, recipeItems, result, experience, weavingTime, true);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.TESSELATING.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.TESSELATING.get();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public boolean m_271738_() {
        return this.showNotification;
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public boolean m_5818_(Container inv, Level level) {
        for (int i = 0; i <= 3 - this.width; ++i) {
            for (int j = 0; j <= 3 - this.height; ++j) {
                if (this.matches(inv, i, j, true)) {
                    return true;
                }
                if (!this.matches(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(Container craftingInventory, int width, int height, boolean mirrored) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int k = x - width;
                int l = y - height;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    Ingredient ingredient2 = ingredient = mirrored ? (Ingredient)this.recipeItems.get(this.width - k - 1 + l * this.width) : (Ingredient)this.recipeItems.get(k + l * this.width);
                }
                if (ingredient.test(craftingInventory.m_8020_(x + y * 3 + 1))) continue;
                return false;
            }
        }
        return true;
    }

    public NonNullList<ItemStack> m_7457_(Container container) {
        NonNullList nonNullList = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 1; i < nonNullList.size(); ++i) {
            Item item = container.m_8020_(i).m_41720_();
            if (!item.m_41470_()) continue;
            nonNullList.set(i, (Object)new ItemStack((ItemLike)item.m_41469_()));
        }
        return nonNullList;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static NonNullList<Ingredient> dissolvePattern(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonNullList = NonNullList.m_122780_((int)(patternWidth * patternHeight), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                nonNullList.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonNullList;
    }

    @VisibleForTesting
    public static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < toShrink.length; ++m) {
            String string = toShrink[m];
            i = Math.min(i, TesselatingRecipe.firstNonSpace(string));
            int n = TesselatingRecipe.lastNonSpace(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] strings = new String[toShrink.length - l - k];
        for (int o = 0; o < strings.length; ++o) {
            strings[o] = toShrink[o + k].substring(i, j + 1);
        }
        return strings;
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> nonNullList = this.m_7527_();
        return nonNullList.isEmpty() || nonNullList.stream().filter(ingredient -> !ingredient.m_43947_()).anyMatch(ingredient -> ingredient.m_43908_().length == 0);
    }

    private static int firstNonSpace(String entry) {
        int i;
        for (i = 0; i < entry.length() && entry.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String entry) {
        int i;
        for (i = entry.length() - 1; i >= 0 && entry.charAt(i) == ' '; --i) {
        }
        return i;
    }

    public static String[] patternFromJson(JsonArray patternArray) {
        String[] strings = new String[patternArray.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = GsonHelper.m_13805_((JsonElement)patternArray.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    public static Map<String, Ingredient> keyFromJson(JsonObject keyEntry) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : keyEntry.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static ItemStack itemStackFromJson(JsonObject stackObject) {
        Item item = TesselatingRecipe.itemFromJson(stackObject);
        if (stackObject.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = GsonHelper.m_13824_((JsonObject)stackObject, (String)"count", (int)1);
        if (i < 1) {
            throw new JsonSyntaxException("Invalid output count: " + i);
        }
        return new ItemStack((ItemLike)item, i);
    }

    public static Item itemFromJson(JsonObject itemObject) {
        String string = GsonHelper.m_13906_((JsonObject)itemObject, (String)"item");
        Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(string)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + string + "'"));
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Invalid item: " + string);
        }
        return item;
    }

    public int weavingTime() {
        return this.weavingTime;
    }

    public float experience() {
        return this.experience;
    }

    public static class Serializer
    implements RecipeSerializer<TesselatingRecipe> {
        public TesselatingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String string = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map<String, Ingredient> map = TesselatingRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] strings = TesselatingRecipe.shrink(TesselatingRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int i = strings[0].length();
            int j = strings.length;
            NonNullList<Ingredient> nonNullList = TesselatingRecipe.dissolvePattern(strings, map, i, j);
            ItemStack itemStack = TesselatingRecipe.itemStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int weavingTime = GsonHelper.m_13824_((JsonObject)json, (String)"weavingtime", (int)200);
            boolean bl = GsonHelper.m_13855_((JsonObject)json, (String)"show_notification", (boolean)true);
            return new TesselatingRecipe(recipeId, string, i, j, nonNullList, itemStack, experience, weavingTime, bl);
        }

        public TesselatingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            int j = buffer.m_130242_();
            String string = buffer.m_130277_();
            NonNullList nonNullList = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            nonNullList.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ItemStack itemStack = buffer.m_130267_();
            float experience = buffer.readFloat();
            int weavingTime = buffer.readInt();
            boolean bl = buffer.readBoolean();
            return new TesselatingRecipe(recipeId, string, i, j, (NonNullList<Ingredient>)nonNullList, itemStack, experience, weavingTime, bl);
        }

        public void toNetwork(FriendlyByteBuf buffer, TesselatingRecipe recipe) {
            buffer.m_130130_(recipe.width);
            buffer.m_130130_(recipe.height);
            buffer.m_130070_(recipe.group);
            recipe.recipeItems.forEach(ingredient -> ingredient.m_43923_(buffer));
            buffer.m_130055_(recipe.result);
            buffer.writeFloat(recipe.experience);
            buffer.writeInt(recipe.weavingTime);
            buffer.writeBoolean(recipe.showNotification);
        }
    }
}

