/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.registry;

import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.dimdev.dimdoors.rift.registry.RegistryVertex;

public class PocketEntrancePointer
extends RegistryVertex {
    private int pocketId;

    public PocketEntrancePointer(ResourceKey<Level> pocketDim, int pocketId) {
        this.setWorld(pocketDim);
        this.pocketId = pocketId;
    }

    public PocketEntrancePointer() {
    }

    @Override
    public RegistryVertex.RegistryVertexType<? extends RegistryVertex> getType() {
        return (RegistryVertex.RegistryVertexType)RegistryVertex.RegistryVertexType.ENTRANCE.get();
    }

    @Override
    public String toString() {
        return "PocketEntrancePointer(pocketDim=" + this.getWorld() + ", pocketId=" + this.pocketId + ")";
    }

    public static CompoundTag toNbt(PocketEntrancePointer vertex) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("id", vertex.id);
        nbt.m_128359_("pocketDim", vertex.getWorld().m_135782_().toString());
        nbt.m_128405_("pocketId", vertex.pocketId);
        return nbt;
    }

    public static PocketEntrancePointer fromNbt(CompoundTag nbt) {
        PocketEntrancePointer pointer = new PocketEntrancePointer((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("pocketDim"))), nbt.m_128451_("pocketId"));
        pointer.id = nbt.m_128342_("id");
        return pointer;
    }

    public int getPocketId() {
        return this.pocketId;
    }
}

