/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.registry;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.rift.registry.PlayerRiftPointer;
import org.dimdev.dimdoors.rift.registry.PocketEntrancePointer;
import org.dimdev.dimdoors.rift.registry.Rift;
import org.dimdev.dimdoors.rift.registry.RiftPlaceholder;

public abstract class RegistryVertex {
    public static final Registrar<RegistryVertexType<?>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("registry_vertex"), (Object[])new RegistryVertexType[0]).build();
    private ResourceKey<Level> world;
    protected UUID id = UUID.randomUUID();

    public void sourceGone(RegistryVertex source) {
    }

    public void targetGone(RegistryVertex target) {
    }

    public void sourceAdded(RegistryVertex source) {
    }

    public void targetAdded(RegistryVertex target) {
    }

    public abstract RegistryVertexType<? extends RegistryVertex> getType();

    public String toString() {
        return "RegistryVertex(dim=" + this.world + ", id=" + this.id + ")";
    }

    public static RegistryVertex fromNbt(CompoundTag nbt) {
        return Objects.requireNonNull((RegistryVertexType)REGISTRY.get(new ResourceLocation(nbt.m_128461_("type")))).fromNbt(nbt);
    }

    public static CompoundTag toNbt(RegistryVertex registryVertex) {
        String type = REGISTRY.getId(registryVertex.getType()).toString();
        CompoundTag nbt = registryVertex.getType().toNbt(registryVertex);
        nbt.m_128359_("type", type);
        return nbt;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    protected ResourceKey<Level> getWorld() {
        return this.world;
    }

    protected void setWorld(ResourceKey<Level> world) {
        this.world = world;
    }

    public static interface RegistryVertexType<T extends RegistryVertex> {
        public static final RegistrySupplier<RegistryVertexType<PlayerRiftPointer>> PLAYER = RegistryVertexType.register("player", PlayerRiftPointer::fromNbt, PlayerRiftPointer::toNbt);
        public static final RegistrySupplier<RegistryVertexType<Rift>> RIFT = RegistryVertexType.register("rift", Rift::fromNbt, Rift::toNbt);
        public static final RegistrySupplier<RegistryVertexType<PocketEntrancePointer>> ENTRANCE = RegistryVertexType.register("entrance", PocketEntrancePointer::fromNbt, PocketEntrancePointer::toNbt);
        public static final RegistrySupplier<RegistryVertexType<RiftPlaceholder>> RIFT_PLACEHOLDER = RegistryVertexType.register("rift_placeholder", RiftPlaceholder::fromNbt, RiftPlaceholder::toNbt);

        public static void register() {
        }

        public T fromNbt(CompoundTag var1);

        public CompoundTag toNbt(RegistryVertex var1);

        public static <T extends RegistryVertex> RegistrySupplier<RegistryVertexType<T>> register(String id, final Function<CompoundTag, T> fromNbt, final Function<T, CompoundTag> toNbt) {
            return REGISTRY.register(DimensionalDoors.id(id), () -> new RegistryVertexType<T>(){

                @Override
                public T fromNbt(CompoundTag nbt) {
                    return (RegistryVertex)fromNbt.apply(nbt);
                }

                @Override
                public CompoundTag toNbt(RegistryVertex registryVertex) {
                    return (CompoundTag)toNbt.apply(registryVertex);
                }
            });
        }
    }
}

