/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.registry;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.GraphUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.registry.PlayerRiftPointer;
import org.dimdev.dimdoors.rift.registry.PocketEntrancePointer;
import org.dimdev.dimdoors.rift.registry.RegistryVertex;
import org.dimdev.dimdoors.rift.registry.Rift;
import org.dimdev.dimdoors.rift.registry.RiftPlaceholder;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.PocketDirectory;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class RiftRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DATA_NAME = "rifts";
    protected DefaultDirectedGraph<RegistryVertex, DefaultEdge> graph = new DefaultDirectedGraph(DefaultEdge.class);
    protected Map<Location, Rift> locationMap = new HashMap<Location, Rift>();
    protected Map<Pocket, PocketEntrancePointer> pocketEntranceMap = new HashMap<Pocket, PocketEntrancePointer>();
    protected Map<UUID, RegistryVertex> uuidMap = new HashMap<UUID, RegistryVertex>();
    protected Map<UUID, PlayerRiftPointer> lastPrivatePocketEntrances = new HashMap<UUID, PlayerRiftPointer>();
    protected Map<UUID, PlayerRiftPointer> lastPrivatePocketExits = new HashMap<UUID, PlayerRiftPointer>();
    protected Map<UUID, PlayerRiftPointer> overworldRifts = new HashMap<UUID, PlayerRiftPointer>();
    protected Map<UUID, Location> overworldLocations = new HashMap<UUID, Location>();

    public static RiftRegistry fromNbt(Map<ResourceKey<Level>, PocketDirectory> pocketRegistry, CompoundTag nbt) {
        RiftRegistry riftRegistry = new RiftRegistry();
        ListTag riftsNBT = nbt.m_128437_(DATA_NAME, 10);
        String riftTypeId = RegistryVertex.REGISTRY.getId((Object)((RegistryVertex.RegistryVertexType)RegistryVertex.RegistryVertexType.RIFT.get())).toString();
        CompletableFuture<List> futureRifts = CompletableFuture.supplyAsync(() -> ((Stream)riftsNBT.parallelStream().unordered()).map(CompoundTag.class::cast).filter(nbtCompound -> nbtCompound.m_128461_("type").equals(riftTypeId)).map(Rift::fromNbt).collect(Collectors.toList()));
        ListTag pocketsNBT = nbt.m_128437_("pockets", 10);
        CompletableFuture<List> futurePockets = CompletableFuture.supplyAsync(() -> pocketsNBT.stream().map(CompoundTag.class::cast).map(PocketEntrancePointer::fromNbt).collect(Collectors.toList()));
        futureRifts.join().forEach(rift -> {
            riftRegistry.graph.addVertex(rift);
            riftRegistry.uuidMap.put(rift.id, (RegistryVertex)rift);
            riftRegistry.locationMap.put(rift.getLocation(), (Rift)rift);
        });
        futurePockets.join().forEach(pocket -> {
            riftRegistry.graph.addVertex(pocket);
            riftRegistry.uuidMap.put(pocket.id, (RegistryVertex)pocket);
            riftRegistry.pocketEntranceMap.put(((PocketDirectory)pocketRegistry.get(pocket.getWorld())).getPocket(pocket.getPocketId()), (PocketEntrancePointer)pocket);
        });
        ListTag linksNBT = nbt.m_128437_("links", 10);
        for (Tag linkNBT : linksNBT) {
            RegistryVertex from = riftRegistry.uuidMap.get(((CompoundTag)linkNBT).m_128342_("from"));
            RegistryVertex to = riftRegistry.uuidMap.get(((CompoundTag)linkNBT).m_128342_("to"));
            if (from == null || to == null) continue;
            riftRegistry.graph.addEdge((Object)from, (Object)to);
        }
        riftRegistry.lastPrivatePocketEntrances = riftRegistry.readPlayerRiftPointers(nbt.m_128437_("last_private_pocket_entrances", 10));
        riftRegistry.lastPrivatePocketExits = riftRegistry.readPlayerRiftPointers(nbt.m_128437_("last_private_pocket_exits", 10));
        riftRegistry.overworldRifts = riftRegistry.readPlayerRiftPointers(nbt.m_128437_("overworld_rifts", 10));
        return riftRegistry;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        CompletableFuture<Pair> futureRiftsAndPocketsNBT = CompletableFuture.supplyAsync(() -> {
            Map<Boolean, List<RegistryVertex>> vertices = ((Stream)this.graph.vertexSet().parallelStream().unordered()).filter(vertex -> vertex instanceof Rift || vertex instanceof PocketEntrancePointer).collect(Collectors.partitioningBy(Rift.class::isInstance));
            CompletableFuture<List> futureRiftsNBT = CompletableFuture.supplyAsync(() -> ((List)vertices.get(true)).parallelStream().map(RegistryVertex::toNbt).collect(Collectors.toList()));
            CompletableFuture<List> futurePocketsNBT = CompletableFuture.supplyAsync(() -> ((List)vertices.get(false)).parallelStream().map(RegistryVertex::toNbt).collect(Collectors.toList()));
            ListTag riftsNBT = new ListTag();
            ListTag pocketsNBT = new ListTag();
            riftsNBT.addAll((Collection)futureRiftsNBT.join());
            pocketsNBT.addAll((Collection)futurePocketsNBT.join());
            return new Pair((Object)riftsNBT, (Object)pocketsNBT);
        });
        CompletableFuture<ListTag> futureLinksNBT = CompletableFuture.supplyAsync(() -> {
            ListTag linksNBT = new ListTag();
            for (DefaultEdge edge : this.graph.edgeSet()) {
                RegistryVertex from = (RegistryVertex)this.graph.getEdgeSource((Object)edge);
                RegistryVertex to = (RegistryVertex)this.graph.getEdgeTarget((Object)edge);
                CompoundTag linkNBT = new CompoundTag();
                linkNBT.m_128362_("from", from.id);
                linkNBT.m_128362_("to", to.id);
                linksNBT.add((Object)linkNBT);
            }
            return linksNBT;
        });
        nbt.m_128365_("last_private_pocket_entrances", (Tag)this.writePlayerRiftPointers(this.lastPrivatePocketEntrances));
        nbt.m_128365_("last_private_pocket_exits", (Tag)this.writePlayerRiftPointers(this.lastPrivatePocketExits));
        nbt.m_128365_("overworld_rifts", (Tag)this.writePlayerRiftPointers(this.overworldRifts));
        Pair riftsAndPocketsNBT = futureRiftsAndPocketsNBT.join();
        nbt.m_128365_(DATA_NAME, (Tag)riftsAndPocketsNBT.getFirst());
        nbt.m_128365_("pockets", (Tag)riftsAndPocketsNBT.getSecond());
        nbt.m_128365_("links", (Tag)futureLinksNBT.join());
        return nbt;
    }

    private Map<UUID, PlayerRiftPointer> readPlayerRiftPointers(ListTag nbt) {
        HashMap<UUID, PlayerRiftPointer> pointerMap = new HashMap<UUID, PlayerRiftPointer>();
        for (Tag entryNBT : nbt) {
            UUID player = ((CompoundTag)entryNBT).m_128342_("player");
            UUID rift = ((CompoundTag)entryNBT).m_128342_("rift");
            PlayerRiftPointer pointer = new PlayerRiftPointer(player);
            pointerMap.put(player, pointer);
            this.uuidMap.put(pointer.id, pointer);
            this.graph.addVertex((Object)pointer);
            this.graph.addEdge((Object)pointer, (Object)this.uuidMap.get(rift));
        }
        return pointerMap;
    }

    private ListTag writePlayerRiftPointers(Map<UUID, PlayerRiftPointer> playerRiftPointerMap) {
        ListTag pointers = new ListTag();
        for (Map.Entry<UUID, PlayerRiftPointer> entry : playerRiftPointerMap.entrySet()) {
            CompoundTag entryNBT = new CompoundTag();
            entryNBT.m_128362_("player", entry.getKey());
            int count = 0;
            for (DefaultEdge edge : this.graph.outgoingEdgesOf((Object)entry.getValue())) {
                entryNBT.m_128362_("rift", ((RegistryVertex)this.graph.getEdgeTarget((Object)edge)).id);
                ++count;
            }
            if (count != 1) {
                throw new RuntimeException("PlayerRiftPointer points to more than one rift");
            }
            pointers.add((Object)entryNBT);
        }
        return pointers;
    }

    public boolean isRiftAt(Location location) {
        Rift possibleRift = this.locationMap.get(location);
        return possibleRift != null && !(possibleRift instanceof RiftPlaceholder);
    }

    public Rift getRift(Location location) {
        Rift rift = this.locationMap.get(location);
        if (rift == null) {
            throw new IllegalArgumentException("There is no rift registered at " + location);
        }
        return rift;
    }

    private Rift getRiftOrPlaceholder(Location location) {
        Rift rift = this.locationMap.get(location);
        if (rift == null) {
            LOGGER.debug("Creating a rift placeholder at " + location);
            rift = new RiftPlaceholder();
            rift.setWorld(location.world);
            rift.setLocation(location);
            this.locationMap.put(location, rift);
            this.uuidMap.put(rift.id, rift);
            this.graph.addVertex((Object)rift);
        }
        return rift;
    }

    public void addRift(Location location) {
        Rift rift;
        LOGGER.debug("Adding rift at " + location);
        RegistryVertex currentRift = this.locationMap.get(location);
        if (currentRift instanceof RiftPlaceholder) {
            LOGGER.info("Converting a rift placeholder at " + location + " into a rift");
            rift = new Rift(location);
            rift.id = currentRift.id;
            GraphUtils.replaceVertex(this.graph, currentRift, rift);
        } else if (currentRift == null) {
            rift = new Rift(location);
            this.graph.addVertex((Object)rift);
        } else {
            throw new IllegalArgumentException("There is already a rift registered at " + location);
        }
        this.uuidMap.put(rift.id, rift);
        this.locationMap.put(location, rift);
        rift.markDirty();
    }

    public void removeRift(Location location) {
        LOGGER.debug("Removing rift at " + location);
        Rift rift = this.getRift(location);
        Set incomingEdges = this.graph.incomingEdgesOf((Object)rift);
        Set outgoingEdges = this.graph.outgoingEdgesOf((Object)rift);
        this.graph.removeVertex((Object)rift);
        this.locationMap.remove(location);
        this.uuidMap.remove(rift.id);
        for (DefaultEdge edge : incomingEdges) {
            ((RegistryVertex)this.graph.getEdgeSource((Object)edge)).targetGone(rift);
        }
        for (DefaultEdge edge : outgoingEdges) {
            ((RegistryVertex)this.graph.getEdgeTarget((Object)edge)).sourceGone(rift);
        }
    }

    private void addEdge(RegistryVertex from, RegistryVertex to) {
        this.graph.addEdge((Object)from, (Object)to);
        if (from instanceof Rift) {
            ((Rift)from).markDirty();
        }
        if (to instanceof Rift) {
            ((Rift)to).markDirty();
        }
    }

    private void removeEdge(RegistryVertex from, RegistryVertex to) {
        this.graph.removeEdge((Object)from, (Object)to);
    }

    public void addLink(Location locationFrom, Location locationTo) {
        LOGGER.debug("Adding link " + locationFrom + " -> " + locationTo);
        Rift from = this.getRiftOrPlaceholder(locationFrom);
        Rift to = this.getRiftOrPlaceholder(locationTo);
        this.addEdge(from, to);
        if (!(from instanceof RiftPlaceholder) && !(to instanceof RiftPlaceholder)) {
            from.targetAdded(to);
            to.sourceAdded(from);
        }
    }

    public void removeLink(Location locationFrom, Location locationTo) {
        LOGGER.debug("Removing link " + locationFrom + " -> " + locationTo);
        Rift from = this.getRift(locationFrom);
        Rift to = this.getRift(locationTo);
        this.removeEdge(from, to);
        from.targetGone(to);
        to.sourceGone(from);
    }

    public void setProperties(Location location, LinkProperties properties) {
        LOGGER.debug("Setting DungeonLinkProperties for rift at " + location + " to " + properties);
        Rift rift = this.getRift(location);
        rift.setProperties(properties);
        rift.markDirty();
    }

    public Set<Location> getPocketEntrances(Pocket pocket) {
        PocketEntrancePointer pointer = this.pocketEntranceMap.get(pocket);
        if (pointer == null) {
            return Collections.emptySet();
        }
        return this.graph.outgoingEdgesOf((Object)pointer).stream().map(arg_0 -> this.graph.getEdgeTarget(arg_0)).map(Rift.class::cast).map(Rift::getLocation).collect(Collectors.toSet());
    }

    public Location getPocketEntrance(Pocket pocket) {
        Set<Location> entrances = this.getPocketEntrances(pocket);
        return entrances.stream().findFirst().orElse(null);
    }

    public void addPocketEntrance(Pocket pocket, Location location) {
        LOGGER.debug("Adding pocket entrance for pocket " + pocket.getId() + " in dimension " + pocket.getWorld() + " at " + location);
        this.addEdge(this.pocketEntranceMap.computeIfAbsent(pocket, p -> {
            PocketEntrancePointer pointer = new PocketEntrancePointer(pocket.getWorld(), pocket.getId());
            pointer.setWorld(pocket.getWorld());
            this.graph.addVertex((Object)pointer);
            this.uuidMap.put(pointer.id, pointer);
            return pointer;
        }), this.getRift(location));
    }

    public Location getPrivatePocketEntrance(UUID playerUUID) {
        PlayerRiftPointer entrancePointer = this.lastPrivatePocketEntrances.get(playerUUID);
        Rift entrance = (Rift)((Object)GraphUtils.followPointer(this.graph, entrancePointer));
        if (entrance != null) {
            return entrance.getLocation();
        }
        return this.getPocketEntrance(DimensionalRegistry.getPrivateRegistry().getPrivatePocket(playerUUID));
    }

    private void setPlayerRiftPointer(UUID playerUUID, Location rift, Map<UUID, PlayerRiftPointer> map) {
        PlayerRiftPointer pointer = map.get(playerUUID);
        if (pointer != null) {
            this.graph.removeVertex((Object)pointer);
            map.remove(playerUUID);
            this.uuidMap.remove(pointer.id);
        }
        if (rift != null) {
            pointer = new PlayerRiftPointer(playerUUID);
            this.graph.addVertex((Object)pointer);
            map.put(playerUUID, pointer);
            this.uuidMap.put(pointer.id, pointer);
            this.addEdge(pointer, this.getRift(rift));
        }
    }

    public void setLastPrivatePocketEntrance(UUID playerUUID, Location rift) {
        LOGGER.debug("Setting last used private pocket entrance for " + playerUUID + " at " + rift);
        this.setPlayerRiftPointer(playerUUID, rift, this.lastPrivatePocketEntrances);
    }

    public Location getPrivatePocketExit(UUID playerUUID) {
        PlayerRiftPointer entrancePointer = this.lastPrivatePocketExits.get(playerUUID);
        Rift entrance = (Rift)((Object)GraphUtils.followPointer(this.graph, entrancePointer));
        return entrance != null ? entrance.getLocation() : null;
    }

    public void setLastPrivatePocketExit(UUID playerUUID, Location rift) {
        LOGGER.debug("Setting last used private pocket exit for " + playerUUID + " at " + rift);
        this.setPlayerRiftPointer(playerUUID, rift, this.lastPrivatePocketExits);
    }

    public Location getOverworldRift(UUID playerUUID) {
        return this.overworldLocations.get(playerUUID);
    }

    public void setOverworldRift(UUID playerUUID, Location rift) {
        this.overworldLocations.put(playerUUID, rift);
    }

    public Collection<Rift> getRifts() {
        return this.locationMap.values();
    }

    public Set<Location> getTargets(Location location) {
        return this.graph.outgoingEdgesOf((Object)this.getRift(location)).stream().map(arg_0 -> this.graph.getEdgeTarget(arg_0)).map(Rift.class::cast).map(rift -> rift.getLocation()).collect(Collectors.toSet());
    }

    public Set<Location> getSources(Location location) {
        return this.graph.incomingEdgesOf((Object)this.getRift(location)).stream().map(arg_0 -> this.graph.getEdgeTarget(arg_0)).map(Rift.class::cast).map(Rift::getLocation).collect(Collectors.toSet());
    }
}

