/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.dimdev.dimdoors.pockets.PocketGenerator;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.targets.GlobalReference;
import org.dimdev.dimdoors.rift.targets.RandomTarget;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.pocket.VirtualLocation;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class DungeonTarget
extends RandomTarget {
    private final ResourceLocation dungeonGroup;

    public DungeonTarget(float newRiftWeight, double weightMaximum, double coordFactor, double positiveDepthFactor, double negativeDepthFactor, Set<Integer> acceptedGroups, boolean noLink, boolean noLinkBack, ResourceLocation dungeonGroup) {
        super(newRiftWeight, weightMaximum, coordFactor, positiveDepthFactor, negativeDepthFactor, acceptedGroups, noLink, noLinkBack);
        this.dungeonGroup = dungeonGroup;
    }

    @Override
    protected Pocket generatePocket(VirtualLocation location, GlobalReference linkTo, LinkProperties props) {
        return PocketGenerator.generateDungeonPocketV2(location, linkTo, props, this.dungeonGroup);
    }

    public static CompoundTag toNbt(DungeonTarget target) {
        CompoundTag nbt = RandomTarget.toNbt(target);
        nbt.m_128359_("dungeonGroup", target.dungeonGroup.toString());
        return nbt;
    }

    @Override
    public VirtualTarget copy() {
        return new DungeonTarget(this.getNewRiftWeight(), this.getNewRiftWeight(), this.getCoordFactor(), this.getPositiveDepthFactor(), this.getNegativeDepthFactor(), this.getAcceptedGroups(), this.isNoLink(), this.isNoLinkBack(), this.dungeonGroup);
    }

    public static DungeonTargetBuilder builder() {
        return new DungeonTargetBuilder();
    }

    public static DungeonTarget fromNbt(CompoundTag nbt) {
        return new DungeonTarget(nbt.m_128457_("newRiftWeight"), nbt.m_128459_("weightMaximum"), nbt.m_128459_("coordFactor"), nbt.m_128459_("positiveDepthFactor"), nbt.m_128459_("negativeDepthFactor"), Arrays.stream(nbt.m_128465_("acceptedGroups")).boxed().collect(Collectors.toSet()), nbt.m_128471_("noLink"), nbt.m_128471_("noLinkBack"), new ResourceLocation(nbt.m_128461_("dungeonGroup")));
    }

    @Override
    public VirtualTarget.VirtualTargetType<? extends VirtualTarget> getType() {
        return (VirtualTarget.VirtualTargetType)VirtualTarget.VirtualTargetType.DUNGEON.get();
    }

    public static class DungeonTargetBuilder
    extends RandomTarget.RandomTargetBuilder {
        private ResourceLocation dungeonGroup = PocketGenerator.ALL_DUNGEONS;

        DungeonTargetBuilder() {
        }

        public DungeonTargetBuilder dungeonGroup(ResourceLocation dungeonGroup) {
            this.dungeonGroup = dungeonGroup;
            return this;
        }

        @Override
        public DungeonTargetBuilder newRiftWeight(float newRiftWeight) {
            return (DungeonTargetBuilder)super.newRiftWeight(newRiftWeight);
        }

        @Override
        public DungeonTargetBuilder weightMaximum(double weightMaximum) {
            return (DungeonTargetBuilder)super.weightMaximum(weightMaximum);
        }

        @Override
        public DungeonTargetBuilder coordFactor(double coordFactor) {
            return (DungeonTargetBuilder)super.coordFactor(coordFactor);
        }

        @Override
        public DungeonTargetBuilder positiveDepthFactor(double positiveDepthFactor) {
            return (DungeonTargetBuilder)super.positiveDepthFactor(positiveDepthFactor);
        }

        @Override
        public DungeonTargetBuilder negativeDepthFactor(double negativeDepthFactor) {
            return (DungeonTargetBuilder)super.negativeDepthFactor(negativeDepthFactor);
        }

        @Override
        public DungeonTargetBuilder acceptedGroups(Set<Integer> acceptedGroups) {
            return (DungeonTargetBuilder)super.acceptedGroups(acceptedGroups);
        }

        @Override
        public DungeonTargetBuilder noLink(boolean noLink) {
            return (DungeonTargetBuilder)super.noLink(noLink);
        }

        @Override
        public DungeonTargetBuilder noLinkBack(boolean noLinkBack) {
            return (DungeonTargetBuilder)super.noLinkBack(noLinkBack);
        }

        @Override
        public DungeonTarget build() {
            return new DungeonTarget(this.newRiftWeight, this.weightMaximum, this.coordFactor, this.positiveDepthFactor, this.negativeDepthFactor, this.acceptedGroups, this.noLink, this.noLinkBack, this.dungeonGroup);
        }
    }
}

