/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.rift.target.EntityTarget;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.UnravelUtil;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.ModDimensions;

public class EscapeTarget
extends VirtualTarget
implements EntityTarget {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Codec<EscapeTarget> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("canEscapeLimbo").forGetter(target -> target.canEscapeLimbo)).apply((Applicative)instance, EscapeTarget::new));
    protected final boolean canEscapeLimbo;

    public EscapeTarget(boolean canEscapeLimbo) {
        this.canEscapeLimbo = canEscapeLimbo;
    }

    @Override
    public boolean receiveEntity(Entity entity, Vec3 relativePos, Rotations relativeAngle, Vec3 relativeVelocity) {
        if (!ModDimensions.isPocketDimension(entity.f_19853_) && !ModDimensions.isLimboDimension(entity.f_19853_)) {
            EntityUtils.chat(entity, (Component)Component.m_237115_((String)"rifts.destinations.escape.not_in_pocket_dim"));
            return false;
        }
        if (ModDimensions.isLimboDimension(entity.f_19853_) && !this.canEscapeLimbo) {
            EntityUtils.chat(entity, (Component)Component.m_237115_((String)"rifts.destinations.escape.cannot_escape_limbo"));
            return false;
        }
        if (entity.m_9236_().f_46443_) {
            return false;
        }
        UUID uuid = entity.m_20148_();
        if (uuid != null) {
            if (entity.f_19853_.m_46003_(uuid) == null) {
                LOGGER.log(org.apache.logging.log4j.Level.ERROR, "Tried to get player for escape target from uuid, but player does not exist, uh oh");
                return false;
            }
            LOGGER.log(org.apache.logging.log4j.Level.INFO, "sending player from limbo to their spawnpoint, good luck!");
            Location destLoc = ((ServerPlayer)entity.f_19853_.m_46003_(uuid)).m_8961_() != null ? new Location((ResourceKey<Level>)((ServerPlayer)entity.f_19853_.m_46003_(uuid)).m_8963_(), ((ServerPlayer)entity.f_19853_.m_46003_(uuid)).m_8961_()) : new Location(DimensionalDoors.getServer().m_129783_(), DimensionalDoors.getServer().m_129783_().m_220360_());
            if (destLoc != null && this.canEscapeLimbo) {
                Location location = destLoc;
                entity = TeleportUtil.teleport(entity, (Level)location.getWorld(), location.getBlockPos(), relativeAngle, relativeVelocity);
                entity.f_19789_ = 0.0f;
                RandomSource random = RandomSource.m_216327_();
                BlockPos.m_121925_((BlockPos)location.pos.m_7918_(0, -3, 0), (int)3, (int)2, (int)3).forEach(pos1 -> {
                    if (random.m_188501_() < 1.0f / (float)location.pos.m_123331_((Vec3i)pos1) * DimensionalDoors.getConfig().getLimboConfig().limboBlocksCorruptingOverworldAmount) {
                        Block block = location.getWorld().m_8055_(pos1).m_60734_();
                        if (UnravelUtil.unravelBlocksMap.containsKey(block)) {
                            location.getWorld().m_46597_(pos1, UnravelUtil.unravelBlocksMap.get(block).m_49966_());
                        } else if (UnravelUtil.whitelistedBlocksForLimboRemoval.contains(block)) {
                            location.getWorld().m_46597_(pos1, ((Block)ModBlocks.UNRAVELLED_FABRIC.get()).m_49966_());
                        }
                    }
                });
            } else {
                if (destLoc == null) {
                    EntityUtils.chat(entity, (Component)Component.m_237115_((String)"rifts.destinations.escape.did_not_use_rift"));
                } else {
                    EntityUtils.chat(entity, (Component)Component.m_237115_((String)"rifts.destinations.escape.rift_has_closed"));
                }
                if (ModDimensions.LIMBO_DIMENSION != null) {
                    entity = TeleportUtil.teleport(entity, (Level)ModDimensions.LIMBO_DIMENSION, new BlockPos(this.location.getX(), this.location.getY(), this.location.getZ()), relativeAngle, relativeVelocity);
                    entity.f_19789_ = 0.0f;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public VirtualTarget.VirtualTargetType<? extends VirtualTarget> getType() {
        return (VirtualTarget.VirtualTargetType)VirtualTarget.VirtualTargetType.ESCAPE.get();
    }

    @Override
    public VirtualTarget copy() {
        return new EscapeTarget(this.canEscapeLimbo);
    }

    public static CompoundTag toNbt(EscapeTarget virtualTarget) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("canEscapeLimbo", virtualTarget.canEscapeLimbo);
        return nbt;
    }

    public static EscapeTarget fromNbt(CompoundTag nbt) {
        return new EscapeTarget(nbt.m_128471_("canEscapeLimbo"));
    }
}

