/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.dimdev.dimdoors.api.rift.target.EntityTarget;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;

public class PocketEntranceMarker
extends VirtualTarget
implements EntityTarget {
    private final float weight;
    private final VirtualTarget ifDestination;
    private final VirtualTarget otherwiseDestination;

    public PocketEntranceMarker() {
        this(1.0f, VirtualTarget.NoneTarget.INSTANCE, VirtualTarget.NoneTarget.INSTANCE);
    }

    public PocketEntranceMarker(float weight, VirtualTarget ifDestination, VirtualTarget otherwiseDestination) {
        this.weight = weight;
        this.ifDestination = ifDestination;
        this.otherwiseDestination = otherwiseDestination;
    }

    public static PocketEntranceMarkerBuilder builder() {
        return new PocketEntranceMarkerBuilder();
    }

    @Override
    public boolean receiveEntity(Entity entity, Vec3 relativePos, Rotations relativeAngle, Vec3 relativeVelocity) {
        EntityUtils.chat(entity, (Component)Component.m_237115_((String)"The entrance of this dungeon has not been converted. If this is a normally generated pocket, please report this bug."));
        return false;
    }

    public float getWeight() {
        return this.weight;
    }

    public VirtualTarget getIfDestination() {
        return this.ifDestination;
    }

    public VirtualTarget getOtherwiseDestination() {
        return this.otherwiseDestination;
    }

    public String toString() {
        return "PocketEntranceMarker(weight=" + this.getWeight() + ", ifDestination=" + this.getIfDestination() + ", otherwiseDestination=" + this.getOtherwiseDestination() + ")";
    }

    public PocketEntranceMarkerBuilder toBuilder() {
        return new PocketEntranceMarkerBuilder().weight(this.weight).ifDestination(this.ifDestination).otherwiseDestination(this.otherwiseDestination);
    }

    @Override
    public VirtualTarget.VirtualTargetType<? extends VirtualTarget> getType() {
        return (VirtualTarget.VirtualTargetType)VirtualTarget.VirtualTargetType.POCKET_ENTRANCE.get();
    }

    @Override
    public VirtualTarget copy() {
        return new PocketEntranceMarker(this.weight, this.ifDestination, this.otherwiseDestination);
    }

    public static CompoundTag toNbt(PocketEntranceMarker target) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("weight", target.weight);
        nbt.m_128365_("ifDestination", (Tag)VirtualTarget.toNbt(target.ifDestination));
        nbt.m_128365_("otherwiseDestination", (Tag)VirtualTarget.toNbt(target.otherwiseDestination));
        return nbt;
    }

    public static PocketEntranceMarker fromNbt(CompoundTag nbt) {
        return PocketEntranceMarker.builder().weight(nbt.m_128457_("weight")).ifDestination(nbt.m_128441_("ifDestination") ? VirtualTarget.fromNbt(nbt.m_128469_("ifDestination")) : VirtualTarget.NoneTarget.INSTANCE).otherwiseDestination(nbt.m_128441_("otherwiseDestination") ? VirtualTarget.fromNbt(nbt.m_128469_("otherwiseDestination")) : VirtualTarget.NoneTarget.INSTANCE).build();
    }

    public static class PocketEntranceMarkerBuilder {
        private float weight;
        private VirtualTarget ifDestination = VirtualTarget.NoneTarget.INSTANCE;
        private VirtualTarget otherwiseDestination = VirtualTarget.NoneTarget.INSTANCE;

        private PocketEntranceMarkerBuilder() {
        }

        public PocketEntranceMarkerBuilder weight(float weight) {
            this.weight = weight;
            return this;
        }

        public PocketEntranceMarkerBuilder ifDestination(VirtualTarget ifDestination) {
            this.ifDestination = ifDestination;
            return this;
        }

        public PocketEntranceMarkerBuilder otherwiseDestination(VirtualTarget otherwiseDestination) {
            this.otherwiseDestination = otherwiseDestination;
            return this;
        }

        public PocketEntranceMarker build() {
            return new PocketEntranceMarker(this.weight, this.ifDestination, this.otherwiseDestination);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("weight", this.weight).append("ifDestination", (Object)this.ifDestination).append("otherwiseDestination", (Object)this.otherwiseDestination).toString();
        }
    }
}

