/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.rift.target.Target;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.math.MathUtil;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.pockets.PocketGenerator;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.registry.Rift;
import org.dimdev.dimdoors.rift.targets.GlobalReference;
import org.dimdev.dimdoors.rift.targets.RiftReference;
import org.dimdev.dimdoors.rift.targets.Targets;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.VirtualLocation;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class RandomTarget
extends VirtualTarget {
    private final float newRiftWeight;
    private final double weightMaximum;
    private final double coordFactor;
    private final double positiveDepthFactor;
    private final double negativeDepthFactor;
    private final Set<Integer> acceptedGroups;
    private final boolean noLink;
    private final boolean noLinkBack;

    public RandomTarget(float newRiftWeight, double weightMaximum, double coordFactor, double positiveDepthFactor, double negativeDepthFactor, Set<Integer> acceptedGroups, boolean noLink, boolean noLinkBack) {
        this.newRiftWeight = newRiftWeight;
        this.weightMaximum = weightMaximum;
        this.coordFactor = coordFactor;
        this.positiveDepthFactor = positiveDepthFactor;
        this.negativeDepthFactor = negativeDepthFactor;
        this.acceptedGroups = acceptedGroups;
        this.noLink = noLink;
        this.noLinkBack = noLinkBack;
    }

    public static RandomTargetBuilder builder() {
        return new RandomTargetBuilder();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Target receiveOther() {
        Location selectedLink;
        VirtualLocation virtualLocationHere = VirtualLocation.fromLocation(this.location);
        HashMap<Location, Float> riftWeights = new HashMap<Location, Float>();
        if (this.newRiftWeight > 0.0f) {
            riftWeights.put(null, Float.valueOf(this.newRiftWeight));
        }
        for (Rift otherRift : DimensionalRegistry.getRiftRegistry().getRifts()) {
            double otherWeight;
            VirtualLocation otherVirtualLocation = VirtualLocation.fromLocation(otherRift.getLocation());
            if (otherRift.getProperties() == null || (otherWeight = otherRift.isDetached() ? (double)otherRift.getProperties().floatingWeight : (double)otherRift.getProperties().getEntranceWeight()) == 0.0 || Sets.intersection(this.acceptedGroups, otherRift.getProperties().getGroups()).isEmpty() || otherRift.getProperties().getLinksRemaining() == 0) continue;
            double depthDifference = otherVirtualLocation.getDepth() - virtualLocationHere.getDepth();
            double coordDistance = Math.sqrt(this.sq(otherVirtualLocation.getX() - virtualLocationHere.getX()) + this.sq(otherVirtualLocation.getZ() - virtualLocationHere.getZ()));
            double depthFactor = depthDifference > 0.0 ? this.positiveDepthFactor : this.negativeDepthFactor;
            double distance = Math.sqrt(this.sq(this.coordFactor * coordDistance) + this.sq(depthFactor * depthDifference));
            double weight = 4.0 * this.weightMaximum / Math.PI * otherWeight / this.sq(this.sq(this.weightMaximum) / distance + distance);
            riftWeights.put(otherRift.getLocation(), Float.valueOf((float)weight));
        }
        if (riftWeights.size() == 0) {
            if (this.newRiftWeight != -1.0f) return null;
            selectedLink = null;
        } else {
            selectedLink = (Location)MathUtil.weightedRandom(riftWeights);
        }
        if (selectedLink == null) {
            double r = Math.random();
            double distance = this.weightMaximum * (2.0 * Math.tan(1.5707963267948966 * r) - 0.5578284481138029 * Math.sqrt(r) * Math.log(r));
            double theta = Math.random() * Math.PI;
            double phi = Math.random() * Math.PI;
            double depth = distance * Math.sin(theta);
            double d = depth > 0.0 ? this.positiveDepthFactor : this.negativeDepthFactor;
            double x = Math.cos(theta) * Math.cos(phi) * distance / this.coordFactor;
            double z = Math.cos(theta) * Math.sin(phi) * distance / this.coordFactor;
            VirtualLocation virtualLocation = new VirtualLocation(virtualLocationHere.getWorld(), virtualLocationHere.getX() + (int)Math.round(x), virtualLocationHere.getZ() + (int)Math.round(z), virtualLocationHere.getDepth() + (int)Math.round(depth /= d));
            if (virtualLocation.getDepth() <= 0) {
                ServerLevel world = DimensionalDoors.getWorld(virtualLocation.getWorld());
                BlockPos pos = world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(virtualLocation.getX(), 0, virtualLocation.getZ()));
                if (pos.m_123342_() == -1) {
                    pos = new BlockPos(virtualLocation.getX(), 0, virtualLocation.getX());
                }
                world.m_46597_(pos, ((Block)ModBlocks.DETACHED_RIFT.get()).m_49966_());
                RiftBlockEntity thisRift = (RiftBlockEntity)this.location.getBlockEntity();
                DetachedRiftBlockEntity riftEntity = (DetachedRiftBlockEntity)world.m_7702_(pos);
                riftEntity.setProperties(thisRift.getProperties().toBuilder().linksRemaining(1).build());
                if (!this.noLinkBack && !riftEntity.getProperties().isOneWay()) {
                    RandomTarget.linkRifts(new Location(world, pos), this.location);
                }
                if (this.noLink) return riftEntity.as(Targets.ENTITY);
                RandomTarget.linkRifts(this.location, new Location(world, pos));
                return riftEntity.as(Targets.ENTITY);
            }
            RiftBlockEntity thisRift = (RiftBlockEntity)this.location.getBlockEntity();
            LinkProperties newLink = thisRift.getProperties() != null ? thisRift.getProperties().toBuilder().linksRemaining(0).build() : null;
            Pocket pocket = this.generatePocket(virtualLocation, new GlobalReference(!this.noLinkBack ? this.location : null), newLink);
            if (this.noLink) return (Target)DimensionalRegistry.getRiftRegistry().getPocketEntrance(pocket).getBlockEntity();
            RandomTarget.linkRifts(this.location, DimensionalRegistry.getRiftRegistry().getPocketEntrance(pocket));
            return (Target)DimensionalRegistry.getRiftRegistry().getPocketEntrance(pocket).getBlockEntity();
        }
        RiftBlockEntity riftEntity = (RiftBlockEntity)selectedLink.getBlockEntity();
        if (!this.noLink) {
            RandomTarget.linkRifts(this.location, selectedLink);
        }
        if (this.noLinkBack || riftEntity.getProperties().isOneWay()) return riftEntity;
        RandomTarget.linkRifts(selectedLink, this.location);
        return riftEntity;
    }

    protected Pocket generatePocket(VirtualLocation location, GlobalReference linkTo, LinkProperties props) {
        return PocketGenerator.generateDungeonPocketV2(location, linkTo, props);
    }

    private static void linkRifts(Location from, Location to) {
        RiftBlockEntity fromBe = (RiftBlockEntity)from.getBlockEntity();
        RiftBlockEntity toBe = (RiftBlockEntity)to.getBlockEntity();
        fromBe.setDestination(RiftReference.tryMakeLocal(from, to));
        fromBe.m_6596_();
        if (toBe.getProperties() != null) {
            toBe.setProperties(toBe.getProperties().withLinksRemaining(toBe.getProperties().getLinksRemaining() - 1));
            toBe.updateProperties();
            toBe.m_6596_();
        }
    }

    private double sq(double a) {
        return a * a;
    }

    public float getNewRiftWeight() {
        return this.newRiftWeight;
    }

    public double getWeightMaximum() {
        return this.weightMaximum;
    }

    public double getCoordFactor() {
        return this.coordFactor;
    }

    public double getPositiveDepthFactor() {
        return this.positiveDepthFactor;
    }

    public double getNegativeDepthFactor() {
        return this.negativeDepthFactor;
    }

    public Set<Integer> getAcceptedGroups() {
        return this.acceptedGroups;
    }

    public boolean isNoLink() {
        return this.noLink;
    }

    public boolean isNoLinkBack() {
        return this.noLinkBack;
    }

    @Override
    public VirtualTarget.VirtualTargetType<? extends VirtualTarget> getType() {
        return (VirtualTarget.VirtualTargetType)VirtualTarget.VirtualTargetType.AVAILABLE_LINK.get();
    }

    @Override
    public VirtualTarget copy() {
        return new RandomTarget(this.newRiftWeight, this.weightMaximum, this.coordFactor, this.positiveDepthFactor, this.negativeDepthFactor, this.acceptedGroups, this.noLink, this.noLinkBack);
    }

    public static CompoundTag toNbt(RandomTarget target) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("newRiftWeight", target.newRiftWeight);
        nbt.m_128347_("weightMaximum", target.weightMaximum);
        nbt.m_128347_("coordFactor", target.coordFactor);
        nbt.m_128347_("positiveDepthFactor", target.positiveDepthFactor);
        nbt.m_128347_("negativeDepthFactor", target.negativeDepthFactor);
        nbt.m_128408_("acceptedGroups", new ArrayList<Integer>(target.acceptedGroups));
        nbt.m_128379_("noLink", target.noLink);
        nbt.m_128379_("noLinkBack", target.noLinkBack);
        return nbt;
    }

    public static RandomTarget fromNbt(CompoundTag nbt) {
        return new RandomTarget(nbt.m_128457_("newRiftWeight"), nbt.m_128459_("weightMaximum"), nbt.m_128459_("coordFactor"), nbt.m_128459_("positiveDepthFactor"), nbt.m_128459_("negativeDepthFactor"), Arrays.stream(nbt.m_128465_("acceptedGroups")).boxed().collect(Collectors.toSet()), nbt.m_128471_("noLink"), nbt.m_128471_("noLinkBack"));
    }

    public static class RandomTargetBuilder {
        protected float newRiftWeight;
        protected double weightMaximum;
        protected double coordFactor;
        protected double positiveDepthFactor;
        protected double negativeDepthFactor;
        protected Set<Integer> acceptedGroups = Collections.emptySet();
        protected boolean noLink;
        protected boolean noLinkBack;

        RandomTargetBuilder() {
        }

        public RandomTargetBuilder newRiftWeight(float newRiftWeight) {
            this.newRiftWeight = newRiftWeight;
            return this;
        }

        public RandomTargetBuilder weightMaximum(double weightMaximum) {
            this.weightMaximum = weightMaximum;
            return this;
        }

        public RandomTargetBuilder coordFactor(double coordFactor) {
            this.coordFactor = coordFactor;
            return this;
        }

        public RandomTargetBuilder positiveDepthFactor(double positiveDepthFactor) {
            this.positiveDepthFactor = positiveDepthFactor;
            return this;
        }

        public RandomTargetBuilder negativeDepthFactor(double negativeDepthFactor) {
            this.negativeDepthFactor = negativeDepthFactor;
            return this;
        }

        public RandomTargetBuilder acceptedGroups(Set<Integer> acceptedGroups) {
            this.acceptedGroups = acceptedGroups;
            return this;
        }

        public RandomTargetBuilder noLink(boolean noLink) {
            this.noLink = noLink;
            return this;
        }

        public RandomTargetBuilder noLinkBack(boolean noLinkBack) {
            this.noLinkBack = noLinkBack;
            return this;
        }

        public RandomTarget build() {
            return new RandomTarget(this.newRiftWeight, this.weightMaximum, this.coordFactor, this.positiveDepthFactor, this.negativeDepthFactor, this.acceptedGroups, this.noLink, this.noLinkBack);
        }
    }
}

