/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.util.schematic;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.dimdev.dimdoors.api.util.BlockBoxUtil;
import org.dimdev.dimdoors.api.util.BlockPlacementType;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.util.schematic.Schematic;
import org.dimdev.dimdoors.util.schematic.SchematicPlacer;
import org.jetbrains.annotations.Nullable;

public class RelativeBlockSample
implements BlockGetter,
LevelWriter {
    public final Schematic schematic;
    private final int[][][] blockData;
    private final int[][] biomeData;
    private final BiMap<BlockState, Integer> blockPalette;
    private final BiMap<Biome, Integer> biomePalette;
    private final Map<BlockPos, BlockState> blockContainer;
    private final Map<BlockPos, Biome> biomeContainer;
    private final Map<BlockPos, CompoundTag> blockEntityContainer;
    private final BiMap<CompoundTag, Vec3> entityContainer;

    public RelativeBlockSample(Schematic schematic) {
        int x;
        this.schematic = schematic;
        this.blockData = SchematicPlacer.getBlockData(schematic);
        this.biomeData = SchematicPlacer.getBiomeData(schematic);
        this.blockPalette = ImmutableBiMap.copyOf(schematic.getBlockPalette());
        this.biomePalette = HashBiMap.create((int)0);
        this.blockContainer = Maps.newHashMap();
        this.biomeContainer = Maps.newHashMap();
        this.blockEntityContainer = Maps.newHashMap();
        int width = schematic.getWidth();
        int height = schematic.getHeight();
        int length = schematic.getLength();
        for (x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    this.m_7731_(new BlockPos(x, y, z), (BlockState)this.blockPalette.inverse().get((Object)this.blockData[x][y][z]), 2);
                }
            }
        }
        if (this.hasBiomes()) {
            for (x = 0; x < width; ++x) {
                for (int z = 0; z < length; ++z) {
                    this.biomeContainer.put(new BlockPos(x, 0, z), (Biome)this.biomePalette.inverse().get((Object)this.biomeData[x][z]));
                }
            }
        }
        for (CompoundTag blockEntityNbt : schematic.getBlockEntities()) {
            int[] arr = blockEntityNbt.m_128465_("Pos");
            BlockPos position = new BlockPos(arr[0], arr[1], arr[2]);
            this.blockEntityContainer.put(position, blockEntityNbt);
        }
        this.entityContainer = HashBiMap.create();
        for (CompoundTag entityNbt : schematic.getEntities()) {
            ListTag doubles = entityNbt.m_128437_("Pos", 6);
            this.entityContainer.put((Object)entityNbt, (Object)new Vec3(doubles.m_128772_(0), doubles.m_128772_(1), doubles.m_128772_(2)));
        }
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        BlockState blockState = this.m_8055_(pos);
        if (blockState.m_60734_() instanceof EntityBlock) {
            return ((EntityBlock)blockState.m_60734_()).m_142194_(pos, blockState);
        }
        return null;
    }

    public BlockState m_8055_(BlockPos pos) {
        return this.blockContainer.get(pos);
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.blockContainer.get(pos).m_60819_();
    }

    public void place(BlockPos origin, WorldGenLevel world, BlockPlacementType placementType, boolean biomes) {
        this.blockContainer.forEach((pos, state) -> {
            BlockPos actualPos = origin.m_121955_((Vec3i)pos);
            world.m_6933_(actualPos, state, 0, 0);
            if (placementType.shouldMarkForUpdate()) {
                ((ServerLevel)world).m_7726_().m_8450_(actualPos);
            }
        });
        for (Map.Entry<BlockPos, CompoundTag> entry : this.blockEntityContainer.entrySet()) {
            BlockEntity blockEntity;
            BlockPos pos2 = entry.getKey();
            BlockPos actualPos = origin.m_121955_((Vec3i)entry.getKey());
            CompoundTag nbt = entry.getValue();
            if (nbt.m_128441_("Id")) {
                nbt.m_128365_("id", nbt.m_128423_("Id"));
                nbt.m_128473_("Id");
            }
            if ((blockEntity = BlockEntity.m_155241_((BlockPos)actualPos, (BlockState)this.m_8055_(pos2), (CompoundTag)nbt)) == null) continue;
            placementType.getBlockEntityPlacer().accept((Level)world.m_6018_(), blockEntity);
        }
        for (Map.Entry<Object, Object> entry : this.entityContainer.entrySet()) {
            CompoundTag nbt = (CompoundTag)entry.getKey();
            ListTag doubles = nbt.m_128437_("Pos", 6);
            Vec3 vec = ((Vec3)entry.getValue()).m_82520_((double)origin.m_123341_(), (double)origin.m_123342_(), (double)origin.m_123343_());
            doubles.set(0, NbtOps.f_128958_.createDouble(vec.f_82479_));
            doubles.set(1, NbtOps.f_128958_.createDouble(vec.f_82480_));
            doubles.set(2, NbtOps.f_128958_.createDouble(vec.f_82481_));
            nbt.m_128365_("Pos", (Tag)doubles);
            Entity entity = (Entity)EntityType.m_20642_((CompoundTag)nbt, (Level)world.m_6018_()).orElseThrow(NoSuchElementException::new);
            world.m_7967_(entity);
        }
    }

    public void place(BlockPos origin, ServerLevel world, ChunkAccess chunk, BlockPlacementType placementType, boolean biomes) {
        ChunkPos pos = chunk.m_7697_();
        BoundingBox chunkBox = BlockBoxUtil.getBox(chunk);
        Vec3i schemDimensions = new Vec3i((int)this.schematic.getWidth(), (int)this.schematic.getHeight(), (int)this.schematic.getLength());
        BoundingBox schemBox = BoundingBox.m_162375_((Vec3i)origin, (Vec3i)origin.m_121955_(schemDimensions).m_7918_(-1, -1, -1));
        if (!schemBox.m_71049_(chunkBox)) {
            return;
        }
        BoundingBox intersection = BlockBoxUtil.intersect(schemBox, chunkBox);
        ServerChunkCache serverChunkManager = world.m_7726_();
        LevelChunkSection[] sections = chunk.m_7103_();
        if (placementType.useSection()) {
            BlockPos.m_121919_((BoundingBox)intersection).forEach(blockPos -> {
                BlockState newState;
                int x = Math.floorMod(blockPos.m_123341_(), 16);
                int y = Math.floorMod(blockPos.m_123342_(), 16);
                int z = Math.floorMod(blockPos.m_123343_(), 16);
                int sectionY = chunk.m_151564_(blockPos.m_123342_());
                LevelChunkSection section = sections[sectionY];
                if (section == null) {
                    sections[sectionY] = section = new LevelChunkSection(sectionY, world.m_9598_().m_175515_(Registries.f_256952_));
                }
                if (section.m_62982_(x, y, z).m_60795_() && (newState = this.blockContainer.get(blockPos.m_121996_((Vec3i)origin))) != null && !newState.m_60795_()) {
                    section.m_62991_(x, y, z, newState, false);
                    if (placementType.shouldMarkForUpdate()) {
                        serverChunkManager.m_8450_(blockPos);
                    }
                }
            });
        } else {
            BlockPos.m_121919_((BoundingBox)intersection).forEach(blockPos -> {
                BlockState newState;
                if (chunk.m_8055_(blockPos).m_60795_() && !(newState = this.blockContainer.get(blockPos.m_121996_((Vec3i)origin))).m_60795_()) {
                    chunk.m_6978_(blockPos, newState, false);
                }
            });
        }
        serverChunkManager.m_7827_().m_9353_(chunk, false);
        this.blockEntityContainer.forEach((blockPos, nbt) -> {
            BlockPos actualPos = blockPos.m_121955_((Vec3i)origin);
            if (intersection.m_71051_((Vec3i)actualPos)) {
                BlockEntity blockEntity;
                if (nbt.m_128441_("Id")) {
                    nbt.m_128365_("id", nbt.m_128423_("Id"));
                    nbt.m_128473_("Id");
                }
                if ((blockEntity = BlockEntity.m_155241_((BlockPos)actualPos, (BlockState)this.m_8055_((BlockPos)blockPos), (CompoundTag)nbt)) != null && !(blockEntity instanceof RiftBlockEntity)) {
                    chunk.m_142169_(blockEntity);
                }
            }
        });
        this.entityContainer.forEach((nbt, vec3d) -> {
            ListTag doubles = nbt.m_128437_("Pos", 6);
            Vec3 vec = vec3d.m_82520_((double)origin.m_123341_(), (double)origin.m_123342_(), (double)origin.m_123343_());
            if (intersection.m_71051_(new Vec3i((int)vec.f_82479_, (int)vec.f_82480_, (int)vec.f_82481_))) {
                doubles.set(0, NbtOps.f_128958_.createDouble(vec.f_82479_));
                doubles.set(1, NbtOps.f_128958_.createDouble(vec.f_82480_));
                doubles.set(2, NbtOps.f_128958_.createDouble(vec.f_82481_));
                nbt.m_128365_("Pos", (Tag)doubles);
                Entity entity = (Entity)EntityType.m_20642_((CompoundTag)nbt, (Level)world.m_6018_()).orElseThrow(NoSuchElementException::new);
                world.m_7654_().execute(() -> world.m_7967_(entity));
            }
        });
    }

    public Map<BlockPos, RiftBlockEntity> getAbsoluteRifts(BlockPos origin) {
        HashMap<BlockPos, RiftBlockEntity> rifts = new HashMap<BlockPos, RiftBlockEntity>();
        this.blockEntityContainer.forEach((blockPos, nbt) -> {
            BlockState state;
            BlockEntity blockEntity;
            BlockPos actualPos = origin.m_121955_((Vec3i)blockPos);
            if (nbt.m_128441_("Id")) {
                nbt.m_128365_("id", nbt.m_128423_("Id"));
                nbt.m_128473_("Id");
            }
            if ((blockEntity = BlockEntity.m_155241_((BlockPos)actualPos, (BlockState)(state = this.m_8055_((BlockPos)blockPos)), (CompoundTag)nbt)) instanceof RiftBlockEntity) {
                rifts.put(actualPos, (RiftBlockEntity)blockEntity);
            }
        });
        return rifts;
    }

    public int[][][] getBlockData() {
        return this.blockData;
    }

    public BiMap<BlockState, Integer> getBlockPalette() {
        return this.blockPalette;
    }

    public Map<BlockPos, BlockState> getBlockContainer() {
        return this.blockContainer;
    }

    public Map<BlockPos, CompoundTag> getBlockEntityContainer() {
        return this.blockEntityContainer;
    }

    public boolean m_6933_(BlockPos pos, BlockState state, int flags, int maxUpdateDepth) {
        this.blockContainer.put(pos, state);
        return true;
    }

    public boolean m_7471_(BlockPos pos, boolean move) {
        return this.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
    }

    public boolean m_7740_(BlockPos pos, boolean drop, @Nullable Entity breakingEntity, int maxUpdateDepth) {
        return this.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
    }

    public boolean hasBiomes() {
        return this.biomeData.length != 0;
    }

    public int m_141928_() {
        return this.schematic.getHeight();
    }

    public int m_141937_() {
        return 0;
    }
}

