/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.util.schematic;

import dev.architectury.platform.Platform;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.BlockPlacementType;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.util.schematic.RelativeBlockSample;
import org.dimdev.dimdoors.util.schematic.Schematic;

public final class SchematicPlacer {
    public static final Logger LOGGER = LogManager.getLogger();

    private SchematicPlacer() {
    }

    public static void place(Schematic schematic, WorldGenLevel world, BlockPos origin, BlockPlacementType placementType) {
        LOGGER.debug("Placing schematic: {}", (Object)schematic.getMetadata().name());
        for (String id : schematic.getMetadata().requiredMods()) {
            if (Platform.isModLoaded((String)id)) continue;
            LOGGER.warn("Schematic \"" + schematic.getMetadata().name() + "\" depends on mod \"" + id + "\", which is missing!");
        }
        RelativeBlockSample blockSample = Schematic.getBlockSample(schematic);
        blockSample.place(origin, world, placementType, false);
    }

    public static Map<BlockPos, RiftBlockEntity> getAbsoluteRifts(Schematic schematic, BlockPos origin) {
        RelativeBlockSample blockSample = Schematic.getBlockSample(schematic);
        return blockSample.getAbsoluteRifts(origin);
    }

    public static void place(Schematic schematic, ServerLevel world, ChunkAccess chunk, BlockPos origin, BlockPlacementType placementType) {
        LOGGER.debug("Placing schematic: {}", (Object)schematic.getMetadata().name());
        for (String id : schematic.getMetadata().requiredMods()) {
            if (Platform.isModLoaded((String)id)) continue;
            LOGGER.warn("Schematic \"" + schematic.getMetadata().name() + "\" depends on mod \"" + id + "\", which is missing!");
        }
        RelativeBlockSample blockSample = Schematic.getBlockSample(schematic);
        blockSample.place(origin, world, chunk, placementType, false);
    }

    public static int[][][] getBlockData(Schematic schematic) {
        int width = schematic.getWidth();
        int height = schematic.getHeight();
        int length = schematic.getLength();
        byte[] blockDataIntArray = schematic.getBlockData().array();
        int[][][] blockData = new int[width][height][length];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    blockData[x][y][z] = blockDataIntArray[x + z * width + y * width * length];
                }
            }
        }
        return blockData;
    }

    public static int[][] getBiomeData(Schematic schematic) {
        return new int[0][0];
    }

    private static void placeEntities(int originX, int originY, int originZ, Schematic schematic, WorldGenLevel world) {
        List<CompoundTag> entityNbts = schematic.getEntities();
        for (CompoundTag nbt : entityNbts) {
            ListTag nbtList = Objects.requireNonNull(nbt.m_128437_("Pos", 6), "Entity in schematic  \"" + schematic.getMetadata().name() + "\" did not have a Pos nbt list!");
            SchematicPlacer.processPos(nbtList, originX, originY, originZ, nbt);
            EntityType entityType = (EntityType)EntityType.m_20637_((CompoundTag)nbt).orElseThrow(AssertionError::new);
            Entity e = entityType.m_20615_((Level)world.m_6018_());
            if (e == null) continue;
            e.m_20258_(nbt);
            world.m_47205_(e);
        }
    }

    public static CompoundTag fixEntityId(CompoundTag nbt) {
        if (!nbt.m_128441_("Id") && nbt.m_128441_("id")) {
            nbt.m_128359_("Id", nbt.m_128461_("id"));
        } else if (nbt.m_128441_("Id") && !nbt.m_128441_("id")) {
            nbt.m_128359_("id", nbt.m_128461_("Id"));
        }
        if (!nbt.m_128441_("Id") || !nbt.m_128441_("id")) {
            System.err.println("An unexpected error occurred parsing this entity");
            System.err.println(nbt.toString());
            throw new IllegalStateException("Entity did not have an 'Id' nbt string, nor an 'id' nbt string!");
        }
        return nbt;
    }

    private static void processPos(ListTag nbtList, int originX, int originY, int originZ, CompoundTag nbt) {
        double x = nbtList.m_128772_(0);
        double y = nbtList.m_128772_(1);
        double z = nbtList.m_128772_(2);
        nbt.m_128473_("Pos");
        nbt.m_128365_("Pos", NbtOps.f_128958_.createList(Stream.of(DoubleTag.m_128500_((double)(x + (double)originX)), DoubleTag.m_128500_((double)(y + (double)originY)), DoubleTag.m_128500_((double)(z + (double)originZ)))));
    }
}

