/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.registries.DeferredRegister;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.world.pocket.BlankChunkGenerator;

public final class ModDimensions {
    public static final ResourceKey<Level> LIMBO = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)DimensionalDoors.id("limbo"));
    public static final ResourceKey<Level> PERSONAL = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)DimensionalDoors.id("personal_pockets"));
    public static final ResourceKey<Level> PUBLIC = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)DimensionalDoors.id("public_pockets"));
    public static final ResourceKey<Level> DUNGEON = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)DimensionalDoors.id("dungeon_pockets"));
    public static final ResourceKey<DimensionType> LIMBO_TYPE_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)DimensionalDoors.id("limbo"));
    public static final ResourceKey<DimensionType> POCKET_TYPE_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)DimensionalDoors.id("personal_pockets"));
    public static DimensionType LIMBO_TYPE;
    public static DimensionType POCKET_TYPE;
    public static ServerLevel LIMBO_DIMENSION;
    public static ServerLevel PERSONAL_POCKET_DIMENSION;
    public static ServerLevel PUBLIC_POCKET_DIMENSION;
    public static ServerLevel DUNGEON_POCKET_DIMENSION;

    public static boolean isPocketDimension(Level world) {
        return ModDimensions.isPocketDimension((ResourceKey<Level>)world.m_46472_());
    }

    public static boolean isPrivatePocketDimension(Level world) {
        return world != null && world == PERSONAL_POCKET_DIMENSION;
    }

    public static boolean isPocketDimension(ResourceKey<Level> type) {
        return Objects.equals(type, PERSONAL) || Objects.equals(type, PUBLIC) || Objects.equals(type, DUNGEON);
    }

    public static boolean isLimboDimension(Level world) {
        return world != null && world.m_46472_().equals(LIMBO);
    }

    public static void init() {
        LifecycleEvent.SERVER_STARTED.register(server -> {
            LIMBO_TYPE = (DimensionType)server.m_206579_().m_175515_(Registries.f_256787_).m_6246_(LIMBO_TYPE_KEY);
            POCKET_TYPE = (DimensionType)server.m_206579_().m_175515_(Registries.f_256787_).m_6246_(POCKET_TYPE_KEY);
            LIMBO_DIMENSION = server.m_129880_(LIMBO);
            PERSONAL_POCKET_DIMENSION = server.m_129880_(PERSONAL);
            PUBLIC_POCKET_DIMENSION = server.m_129880_(PUBLIC);
            DUNGEON_POCKET_DIMENSION = server.m_129880_(DUNGEON);
        });
        DeferredRegister deffered = DeferredRegister.create((String)"dimdoors", (ResourceKey)Registries.f_256783_);
        deffered.register("blank", () -> BlankChunkGenerator.CODEC);
        deffered.register();
    }
}

