/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.ResourceUtil;
import org.dimdev.dimdoors.network.ExtendedServerPlayNetworkHandler;
import org.dimdev.dimdoors.network.packet.s2c.RenderBreakBlockS2CPacket;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.dimdev.dimdoors.world.decay.DecayPattern;

public final class Decay {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceKey<Level>, Set<DecayTask>> DECAY_QUEUE = new HashMap<ResourceKey<Level>, Set<DecayTask>>();
    private static final RandomSource RANDOM = RandomSource.m_216327_();

    public static void applySpreadDecay(ServerLevel world, BlockPos pos) {
        if (RANDOM.m_188500_() < DimensionalDoors.getConfig().getDecayConfig().decaySpreadChance) {
            BlockState origin = world.m_8055_(pos);
            int decayAmount = RANDOM.m_188503_(5) + 1;
            ArrayList<Direction> directions = new ArrayList<Direction>(Arrays.asList(Direction.values()));
            for (int i = 0; i < decayAmount; ++i) {
                Decay.decayBlock(world, pos.m_121945_((Direction)directions.remove(RANDOM.m_188503_(5 - i))), origin);
            }
        }
    }

    public static void decayBlock(ServerLevel world, BlockPos pos, BlockState origin) {
        BlockState targetState = world.m_8055_(pos);
        FluidState fluidState = world.m_6425_(pos);
        Collection<DecayPattern> patterns = DecayLoader.getInstance().getPatterns(targetState.m_60734_());
        if (patterns.isEmpty()) {
            patterns = DecayLoader.getInstance().getPatterns(fluidState.m_76152_());
        }
        if (patterns.isEmpty()) {
            return;
        }
        for (DecayPattern pattern : patterns) {
            if (!pattern.test((Level)world, pos, origin, targetState, fluidState)) continue;
            world.m_8795_(EntitySelector.m_20410_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)100.0)).forEach(player -> ExtendedServerPlayNetworkHandler.get(player.f_8906_).getDimDoorsPacketHandler().sendPacket(new RenderBreakBlockS2CPacket(pos, 5)));
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)ModSoundEvents.TEARING.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
            Decay.queueDecay(world, pos, origin, pattern, DimensionalDoors.getConfig().getDecayConfig().decayDelay);
            break;
        }
    }

    public static void queueDecay(ServerLevel world, BlockPos pos, BlockState origin, DecayPattern pattern, int delay) {
        DecayTask task = new DecayTask(pos, origin, pattern, delay);
        if (delay <= 0) {
            task.process(world);
        } else {
            DECAY_QUEUE.computeIfAbsent((ResourceKey<Level>)world.m_46472_(), k -> new HashSet()).add(task);
        }
    }

    public static void tick(ServerLevel world) {
        ResourceKey key = world.m_46472_();
        if (DECAY_QUEUE.containsKey(key)) {
            Set<DecayTask> tasks = DECAY_QUEUE.get(key);
            Set<DecayTask> tasksToRun = tasks.stream().filter(DecayTask::reduceDelayIsDone).collect(Collectors.toSet());
            tasks.removeAll(tasksToRun);
            tasksToRun.forEach(task -> task.process(world));
        }
    }

    public static class DecayLoader
    implements ResourceManagerReloadListener {
        private static final Logger LOGGER = LogManager.getLogger();
        private static final DecayLoader INSTANCE = new DecayLoader();
        private final Map<Block, List<DecayPattern>> blockPatterns = new HashMap<Block, List<DecayPattern>>();
        private final Map<Fluid, List<DecayPattern>> fluidPatterns = new HashMap<Fluid, List<DecayPattern>>();

        private DecayLoader() {
        }

        public static DecayLoader getInstance() {
            return INSTANCE;
        }

        public void m_6213_(ResourceManager manager) {
            this.blockPatterns.clear();
            CompletableFuture futurePatternList = ResourceUtil.loadResourcePathToCollection(manager, "decay_patterns", ".json", new ArrayList(), ResourceUtil.NBT_READER.andThenReader(this::loadPattern));
            for (DecayPattern pattern : (List)futurePatternList.join()) {
                for (Block block : pattern.constructApplicableBlocks()) {
                    this.blockPatterns.computeIfAbsent(block, b -> new ArrayList());
                    this.blockPatterns.get(block).add(pattern);
                }
                for (Fluid fluid : pattern.constructApplicableFluids()) {
                    this.fluidPatterns.computeIfAbsent(fluid, b -> new ArrayList());
                    this.fluidPatterns.get(fluid).add(pattern);
                }
            }
        }

        private DecayPattern loadPattern(Tag nbt, ResourceLocation ignored) {
            return DecayPattern.deserialize((CompoundTag)nbt);
        }

        public Collection<DecayPattern> getPatterns(Block block) {
            return this.blockPatterns.getOrDefault(block, new ArrayList());
        }

        public Collection<DecayPattern> getPatterns(Fluid fluid) {
            return this.fluidPatterns.getOrDefault(fluid, new ArrayList());
        }
    }

    private static class DecayTask {
        private final BlockPos pos;
        private final BlockState origin;
        private final DecayPattern processor;
        private int delay;

        public DecayTask(BlockPos pos, BlockState origin, DecayPattern processor, int delay) {
            this.pos = pos;
            this.origin = origin;
            this.processor = processor;
            this.delay = delay;
        }

        public boolean reduceDelayIsDone() {
            return --this.delay <= 0;
        }

        public void process(ServerLevel world) {
            BlockState targetBlock = world.m_8055_(this.pos);
            FluidState targetFluid = world.m_6425_(this.pos);
            if (world.m_201918_(this.pos) && this.processor.test((Level)world, this.pos, this.origin, targetBlock, targetFluid)) {
                world.m_8795_(EntitySelector.m_20410_((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), (double)100.0)).forEach(player -> ExtendedServerPlayNetworkHandler.get(player.f_8906_).getDimDoorsPacketHandler().sendPacket(new RenderBreakBlockS2CPacket(this.pos, -1)));
                world.m_6263_(null, (double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), targetBlock.m_60827_().m_56775_(), SoundSource.BLOCKS, 0.5f, 1.0f);
                this.processor.process((Level)world, this.pos, this.origin, targetBlock, targetFluid);
            }
        }
    }
}

