/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.world.decay.predicates.FluidDecayPredicate;
import org.dimdev.dimdoors.world.decay.predicates.SimpleDecayPredicate;

public interface DecayPredicate {
    public static final Registrar<DecayPredicateType<? extends DecayPredicate>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("decay_predicate_type"), (Object[])new DecayPredicateType[0]).build();
    public static final DecayPredicate NONE = new DecayPredicate(){
        private static final String ID = "none";

        @Override
        public DecayPredicate fromNbt(CompoundTag nbt) {
            return this;
        }

        @Override
        public DecayPredicateType<? extends DecayPredicate> getType() {
            return (DecayPredicateType)DecayPredicateType.NONE_PREDICATE_TYPE.get();
        }

        @Override
        public String getKey() {
            return ID;
        }

        @Override
        public boolean test(Level world, BlockPos pos, BlockState origin, BlockState targetBlock, FluidState targetFluid) {
            return false;
        }
    };

    public static DecayPredicate deserialize(CompoundTag nbt) {
        ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_128461_("type"));
        return ((DecayPredicateType)REGISTRY.delegate(id).orElseGet(DecayPredicateType.NONE_PREDICATE_TYPE)).fromNbt(nbt);
    }

    public static CompoundTag serialize(DecayPredicate modifier) {
        return modifier.toNbt(new CompoundTag());
    }

    public DecayPredicate fromNbt(CompoundTag var1);

    default public CompoundTag toNbt(CompoundTag nbt) {
        return this.getType().toNbt(nbt);
    }

    public DecayPredicateType<? extends DecayPredicate> getType();

    public String getKey();

    public boolean test(Level var1, BlockPos var2, BlockState var3, BlockState var4, FluidState var5);

    default public Set<Fluid> constructApplicableFluids() {
        return Set.of();
    }

    default public Set<Block> constructApplicableBlocks() {
        return Set.of();
    }

    public static interface DecayPredicateType<T extends DecayPredicate> {
        public static final RegistrySupplier<DecayPredicateType<DecayPredicate>> NONE_PREDICATE_TYPE = DecayPredicateType.register(DimensionalDoors.id("none"), () -> NONE);
        public static final RegistrySupplier<DecayPredicateType<DecayPredicate>> SIMPLE_PREDICATE_TYPE = DecayPredicateType.register(DimensionalDoors.id("block"), SimpleDecayPredicate::new);
        public static final RegistrySupplier<DecayPredicateType<DecayPredicate>> FLUID_PREDICATE_TYPE = DecayPredicateType.register(DimensionalDoors.id("fluid"), FluidDecayPredicate::new);

        public DecayPredicate fromNbt(CompoundTag var1);

        public CompoundTag toNbt(CompoundTag var1);

        public static void register() {
        }

        public static <U extends DecayPredicate> RegistrySupplier<DecayPredicateType<U>> register(final ResourceLocation id, final Supplier<U> factory) {
            return REGISTRY.register(id, () -> new DecayPredicateType<U>(){

                @Override
                public DecayPredicate fromNbt(CompoundTag nbt) {
                    return ((DecayPredicate)factory.get()).fromNbt(nbt);
                }

                @Override
                public CompoundTag toNbt(CompoundTag nbt) {
                    nbt.m_128359_("type", id.toString());
                    return nbt;
                }
            });
        }
    }
}

