/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.world.decay.processors.BlockDecayProcessor;
import org.dimdev.dimdoors.world.decay.processors.DoorDecayProccessor;
import org.dimdev.dimdoors.world.decay.processors.DoubleDecayProcessor;
import org.dimdev.dimdoors.world.decay.processors.FluidDecayProcessor;
import org.dimdev.dimdoors.world.decay.processors.SelfDecayProcessor;

public interface DecayProcessor {
    public static final Registrar<DecayProcessorType<? extends DecayProcessor>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("decay_processor_type"), (Object[])new DecayProcessorType[0]).build();
    public static final DecayProcessor NONE = new DecayProcessor(){
        private static final String ID = "none";

        @Override
        public DecayProcessor fromNbt(CompoundTag nbt) {
            return this;
        }

        @Override
        public DecayProcessorType<? extends DecayProcessor> getType() {
            return (DecayProcessorType)DecayProcessorType.NONE_PROCESSOR_TYPE.get();
        }

        @Override
        public String getKey() {
            return ID;
        }

        @Override
        public int process(Level world, BlockPos pos, BlockState origin, BlockState targetBlock, FluidState targetFluid) {
            return 0;
        }
    };

    public static DecayProcessor deserialize(CompoundTag nbt) {
        ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_128461_("type"));
        return ((DecayProcessorType)REGISTRY.delegate(id).orElseGet(DecayProcessorType.NONE_PROCESSOR_TYPE)).fromNbt(nbt);
    }

    public static CompoundTag serialize(DecayProcessor modifier) {
        return modifier.toNbt(new CompoundTag());
    }

    public DecayProcessor fromNbt(CompoundTag var1);

    default public CompoundTag toNbt(CompoundTag nbt) {
        return this.getType().toNbt(nbt);
    }

    public DecayProcessorType<? extends DecayProcessor> getType();

    public String getKey();

    public int process(Level var1, BlockPos var2, BlockState var3, BlockState var4, FluidState var5);

    public static interface DecayProcessorType<T extends DecayProcessor> {
        public static final RegistrySupplier<DecayProcessorType<BlockDecayProcessor>> SIMPLE_PROCESSOR_TYPE = DecayProcessorType.register(DimensionalDoors.id("block"), BlockDecayProcessor::new);
        public static final RegistrySupplier<DecayProcessorType<DecayProcessor>> NONE_PROCESSOR_TYPE = DecayProcessorType.register(DimensionalDoors.id("none"), () -> NONE);
        public static final RegistrySupplier<DecayProcessorType<SelfDecayProcessor>> SELF = DecayProcessorType.register(DimensionalDoors.id("self"), SelfDecayProcessor::instance);
        public static final RegistrySupplier<DecayProcessorType<DoorDecayProccessor>> DOOR_PROCESSOR_TYPE = DecayProcessorType.register(DimensionalDoors.id("door"), DoorDecayProccessor::new);
        public static final RegistrySupplier<DecayProcessorType<DoubleDecayProcessor>> DOUBLE_PROCESSOR_TYPE = DecayProcessorType.register(DimensionalDoors.id("double"), DoubleDecayProcessor::new);
        public static final RegistrySupplier<DecayProcessorType<FluidDecayProcessor>> FLUID_PROCESSOR_TYPE = DecayProcessorType.register(DimensionalDoors.id("fluid"), FluidDecayProcessor::new);

        public DecayProcessor fromNbt(CompoundTag var1);

        public CompoundTag toNbt(CompoundTag var1);

        public static void register() {
        }

        public static <U extends DecayProcessor> RegistrySupplier<DecayProcessorType<U>> register(final ResourceLocation id, final Supplier<U> factory) {
            return REGISTRY.register(id, () -> new DecayProcessorType<U>(){

                @Override
                public DecayProcessor fromNbt(CompoundTag nbt) {
                    return ((DecayProcessor)factory.get()).fromNbt(nbt);
                }

                @Override
                public CompoundTag toNbt(CompoundTag nbt) {
                    nbt.m_128359_("type", id.toString());
                    return nbt;
                }
            });
        }
    }
}

