/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay.predicates;

import com.google.common.collect.Streams;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.dimdev.dimdoors.world.decay.DecayPredicate;

public class FluidDecayPredicate
implements DecayPredicate {
    public static final String KEY = "fluid";
    private Fluid fluid;
    private TagKey<Fluid> tag;

    public FluidDecayPredicate() {
    }

    public FluidDecayPredicate(TagKey<Fluid> tag, Fluid fluid) {
        this.tag = tag;
        this.fluid = fluid;
    }

    @Override
    public DecayPredicate fromNbt(CompoundTag nbt) {
        String name = nbt.m_128461_("entry");
        if (name.startsWith("#")) {
            this.tag = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)ResourceLocation.m_135820_((String)name.substring(1)));
        } else {
            this.fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(ResourceLocation.m_135820_((String)name));
        }
        return this;
    }

    @Override
    public CompoundTag toNbt(CompoundTag nbt) {
        DecayPredicate.super.toNbt(nbt);
        nbt.m_128359_("entry", (String)(this.tag != null ? "#" + this.tag.f_203868_().toString() : BuiltInRegistries.f_257020_.m_7981_((Object)this.fluid).toString()));
        return nbt;
    }

    @Override
    public DecayPredicate.DecayPredicateType<? extends DecayPredicate> getType() {
        return (DecayPredicate.DecayPredicateType)DecayPredicate.DecayPredicateType.FLUID_PREDICATE_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public boolean test(Level world, BlockPos pos, BlockState origin, BlockState targetBlock, FluidState targetFluid) {
        return targetFluid.m_76170_() && (targetFluid.m_76152_() == this.fluid || targetFluid.m_205070_(this.tag));
    }

    @Override
    public Set<Fluid> constructApplicableFluids() {
        return this.fluid != null ? Set.of(this.fluid) : Streams.stream((Iterable)BuiltInRegistries.f_257020_.m_206058_(this.tag)).map(Holder::m_203334_).collect(Collectors.toSet());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Fluid fluid;
        private TagKey<Fluid> tag;

        public Builder fluid(Fluid fluid) {
            this.fluid = fluid;
            return this;
        }

        public Builder tag(TagKey<Fluid> tag) {
            this.tag = tag;
            return this;
        }

        public FluidDecayPredicate create() {
            return new FluidDecayPredicate(this.tag, this.fluid);
        }
    }
}

