/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay.predicates;

import com.google.common.collect.Streams;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.dimdev.dimdoors.world.decay.DecayPredicate;

public class SimpleDecayPredicate
implements DecayPredicate {
    public static final String KEY = "block";
    private Block block;
    private TagKey<Block> tag;

    public SimpleDecayPredicate() {
    }

    public SimpleDecayPredicate(TagKey<Block> tag, Block block) {
        this.tag = tag;
        this.block = block;
    }

    @Override
    public DecayPredicate fromNbt(CompoundTag nbt) {
        String name = nbt.m_128461_("entry");
        if (name.startsWith("#")) {
            this.tag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)ResourceLocation.m_135820_((String)name.substring(1)));
        } else {
            this.block = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)name));
        }
        return this;
    }

    @Override
    public CompoundTag toNbt(CompoundTag nbt) {
        DecayPredicate.super.toNbt(nbt);
        nbt.m_128359_("entry", (String)(this.tag != null ? "#" + this.tag.f_203868_().toString() : BuiltInRegistries.f_256975_.m_7981_((Object)this.block).toString()));
        return nbt;
    }

    @Override
    public DecayPredicate.DecayPredicateType<? extends DecayPredicate> getType() {
        return (DecayPredicate.DecayPredicateType)DecayPredicate.DecayPredicateType.SIMPLE_PREDICATE_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public boolean test(Level world, BlockPos pos, BlockState origin, BlockState targetBlock, FluidState targetFluid) {
        return this.block != null ? targetBlock.m_60713_(this.block) : targetBlock.m_204336_(this.tag);
    }

    @Override
    public Set<Block> constructApplicableBlocks() {
        return this.block != null ? Set.of(this.block) : Streams.stream((Iterable)BuiltInRegistries.f_256975_.m_206058_(this.tag)).map(Holder::m_203334_).collect(Collectors.toSet());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Block block;
        private TagKey<Block> tag;

        public Builder block(Block block) {
            this.block = block;
            return this;
        }

        public Builder tag(TagKey<Block> tag) {
            this.tag = tag;
            return this;
        }

        public SimpleDecayPredicate create() {
            return new SimpleDecayPredicate(this.tag, this.block);
        }
    }
}

