/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay.processors;

import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.dimdev.dimdoors.world.decay.DecayProcessor;

public class BlockDecayProcessor
implements DecayProcessor {
    public static final String KEY = "block";
    protected Block block;
    protected int entropy;

    public BlockDecayProcessor() {
    }

    protected BlockDecayProcessor(Block block, int entropy) {
        this.block = block;
        this.entropy = entropy;
    }

    @Override
    public DecayProcessor fromNbt(CompoundTag json) {
        this.block = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)json.m_128461_(KEY)));
        this.entropy = json.m_128451_("entropy");
        return this;
    }

    @Override
    public CompoundTag toNbt(CompoundTag nbt) {
        DecayProcessor.super.toNbt(nbt);
        nbt.m_128359_(KEY, BuiltInRegistries.f_256975_.m_7981_((Object)this.block).toString());
        nbt.m_128405_("entropy", this.entropy);
        return nbt;
    }

    @Override
    public DecayProcessor.DecayProcessorType<? extends DecayProcessor> getType() {
        return (DecayProcessor.DecayProcessorType)DecayProcessor.DecayProcessorType.SIMPLE_PROCESSOR_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int process(Level world, BlockPos pos, BlockState origin, BlockState target, FluidState targetFluid) {
        BlockState newState = this.block.m_49966_();
        if (target.m_60734_() instanceof DoublePlantBlock) {
            pos = target.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER ? pos.m_7494_() : pos;
        }
        Set commonProperties = target.m_61147_().stream().filter(newState.m_61147_()::contains).collect(Collectors.toSet());
        for (Property property : commonProperties) {
            newState = BlockDecayProcessor.transferProperty(target, newState, property);
        }
        world.m_46597_(pos, newState);
        return this.entropy;
    }

    private static <T extends Comparable<T>> BlockState transferProperty(BlockState from, BlockState to, Property<T> property) {
        return (BlockState)to.m_61124_(property, from.m_61143_(property));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Block block = Blocks.f_50016_;
        private int entropy;

        public Builder block(Block block) {
            this.block = block;
            return this;
        }

        public Builder entropy(int entropy) {
            this.entropy = entropy;
            return this;
        }

        public BlockDecayProcessor create() {
            return new BlockDecayProcessor(this.block, this.entropy);
        }
    }
}

