/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay.processors;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.dimdev.dimdoors.world.decay.DecayProcessor;

public class DoubleDecayProcessor
implements DecayProcessor {
    public static final String KEY = "double";
    protected Block block;
    protected int entropy;

    public DoubleDecayProcessor() {
    }

    protected DoubleDecayProcessor(Block block, int entropy) {
        this.block = block;
        this.entropy = entropy;
    }

    @Override
    public DecayProcessor fromNbt(CompoundTag json) {
        this.block = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)json.m_128461_("block")));
        this.entropy = json.m_128451_("entropy");
        return this;
    }

    @Override
    public CompoundTag toNbt(CompoundTag nbt) {
        DecayProcessor.super.toNbt(nbt);
        nbt.m_128359_("block", BuiltInRegistries.f_256975_.m_7981_((Object)this.block).toString());
        nbt.m_128405_("entropy", this.entropy);
        return nbt;
    }

    @Override
    public DecayProcessor.DecayProcessorType<? extends DecayProcessor> getType() {
        return (DecayProcessor.DecayProcessorType)DecayProcessor.DecayProcessorType.DOOR_PROCESSOR_TYPE.get();
    }

    @Override
    public String getKey() {
        return null;
    }

    @Override
    public int process(Level world, BlockPos pos, BlockState origin, BlockState target, FluidState targetFluid) {
        if (target.m_60734_() instanceof DoorBlock) {
            BlockPos otherPos = target.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos.m_7494_();
            Direction facing = (Direction)target.m_61143_((Property)DoorBlock.f_52726_);
            if (((Boolean)target.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
                facing = target.m_61143_((Property)DoorBlock.f_52728_) == DoorHingeSide.RIGHT ? facing.m_122428_() : facing.m_122427_();
            }
            BlockState newState = (BlockState)((BlockState)this.block.m_49966_().m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)TrapDoorBlock.f_54117_, (Comparable)facing);
            world.m_46597_(pos, newState);
            world.m_46597_(otherPos, newState);
            return this.entropy;
        }
        if (target.m_60734_() instanceof BedBlock) {
            BlockPos otherPos = pos.m_121945_(BedBlock.m_49557_((BlockState)target));
            BlockState newState = this.block.m_49966_();
            world.m_46597_(pos, newState);
            world.m_46597_(otherPos, newState);
        }
        return 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Block block = Blocks.f_50016_;
        private int entropy;

        public Builder block(Block block) {
            this.block = block;
            return this;
        }

        public Builder entropy(int entropy) {
            this.entropy = entropy;
            return this;
        }

        public DoubleDecayProcessor create() {
            return new DoubleDecayProcessor(this.block, this.entropy);
        }
    }
}

