/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay.processors;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.dimdev.dimdoors.world.decay.DecayProcessor;

public class FluidDecayProcessor
implements DecayProcessor {
    public static final String KEY = "fluid";
    protected Fluid fluid;
    protected int entropy;

    public FluidDecayProcessor() {
    }

    protected FluidDecayProcessor(Fluid fluid, int entropy) {
        this.fluid = fluid;
        this.entropy = entropy;
    }

    @Override
    public DecayProcessor fromNbt(CompoundTag json) {
        this.fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(ResourceLocation.m_135820_((String)json.m_128461_(KEY)));
        this.entropy = json.m_128451_("entropy");
        return this;
    }

    @Override
    public CompoundTag toNbt(CompoundTag nbt) {
        DecayProcessor.super.toNbt(nbt);
        nbt.m_128359_("block", BuiltInRegistries.f_257020_.m_7981_((Object)this.fluid).toString());
        nbt.m_128405_("entropy", this.entropy);
        return nbt;
    }

    @Override
    public DecayProcessor.DecayProcessorType<? extends DecayProcessor> getType() {
        return (DecayProcessor.DecayProcessorType)DecayProcessor.DecayProcessorType.FLUID_PROCESSOR_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int process(Level world, BlockPos pos, BlockState origin, BlockState target, FluidState targetFluid) {
        BlockState newState = this.fluid.m_76145_().m_76188_();
        world.m_46597_(pos, newState);
        return this.entropy;
    }

    private static <T extends Comparable<T>> FluidState transferProperty(FluidState from, FluidState to, Property<T> property) {
        return (FluidState)to.m_61124_(property, from.m_61143_(property));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Fluid fluid = Fluids.f_76191_;
        private int entropy;

        public Builder fluid(Fluid fluid) {
            this.fluid = fluid;
            return this;
        }

        public Builder entropy(int entropy) {
            this.entropy = entropy;
            return this;
        }

        public FluidDecayProcessor create() {
            return new FluidDecayProcessor(this.fluid, this.entropy);
        }
    }
}

