/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.feature;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.world.feature.forge.ModFeaturesPlacedImpl;
import org.dimdev.dimdoors.world.feature.gateway.LimboGatewayFeature;
import org.dimdev.dimdoors.world.feature.gateway.schematic.EndGateway;
import org.dimdev.dimdoors.world.feature.gateway.schematic.SandstonePillarsGateway;
import org.dimdev.dimdoors.world.feature.gateway.schematic.SchematicGatewayFeature;
import org.dimdev.dimdoors.world.feature.gateway.schematic.SchematicGatewayFeatureConfig;
import org.dimdev.dimdoors.world.feature.gateway.schematic.TwoPillarsGateway;

public final class ModFeatures {
    public static final SandstonePillarsGateway SANDSTONE_PILLARS_GATEWAY = new SandstonePillarsGateway();
    public static final TwoPillarsGateway TWO_PILLARS_GATEWAY = new TwoPillarsGateway();
    public static final EndGateway END_GATEWAY = new EndGateway();
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((String)"dimdoors", (ResourceKey)Registries.f_256833_);
    public static final RegistrySupplier<Feature<SchematicGatewayFeatureConfig>> SANDSTONE_PILLARS_GATEWAY_FEATURE = FEATURES.register("two_pillars", () -> new SchematicGatewayFeature(SchematicGatewayFeatureConfig.CODEC));
    public static final RegistrySupplier<Feature<SchematicGatewayFeatureConfig>> TWO_PILLARS_GATEWAY_FEATURE = FEATURES.register("sandstone_pillars", () -> new SchematicGatewayFeature(SchematicGatewayFeatureConfig.CODEC));
    public static final RegistrySupplier<Feature<SchematicGatewayFeatureConfig>> END_GATEWAY_FEATURE = FEATURES.register("schematic_gateway", () -> new SchematicGatewayFeature(SchematicGatewayFeatureConfig.CODEC));
    public static final RegistrySupplier<Feature<NoneFeatureConfiguration>> LIMBO_GATEWAY_FEATURE = FEATURES.register("limbo_gateway", LimboGatewayFeature::new);

    public static void init() {
        LifecycleEvent.SETUP.register(() -> {
            SANDSTONE_PILLARS_GATEWAY.init();
            TWO_PILLARS_GATEWAY.init();
            END_GATEWAY.init();
        });
        FEATURES.register();
        Configured.init();
        Placed.init();
    }

    public static final class Configured {
        public static final ResourceKey<ConfiguredFeature<?, ?>> SANDSTONE_PILLARS = Configured.of("sandstone_pillars");
        public static final ResourceKey<ConfiguredFeature<?, ?>> TWO_PILLARS = Configured.of("two_pillars");
        public static final ResourceKey<ConfiguredFeature<?, ?>> END_GATEWAY = Configured.of("end_gateway");
        public static final ResourceKey<ConfiguredFeature<?, ?>> LIMBO_GATEWAY = Configured.of("limbo_gateway");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SOLID_STATIC_ORE = Configured.of("solid_static_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> DECAYED_BLOCK_ORE = Configured.of("decayed_block_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> ETERNAL_FLUID_SPRING = Configured.of("eternal_fluid_spring");

        public static void init() {
        }

        public static ResourceKey<ConfiguredFeature<?, ?>> of(String id) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)DimensionalDoors.id(id));
        }
    }

    public static class Placed {
        public static final ResourceKey<PlacedFeature> SANDSTONE_PILLARS = Placed.of("sandstone_pillars");
        public static final ResourceKey<PlacedFeature> TWO_PILLARS = Placed.of("two_pillars");
        public static final ResourceKey<PlacedFeature> END_GATEWAY = Placed.of("end_gateway");
        public static final ResourceKey<PlacedFeature> LIMBO_GATEWAY = Placed.of("limbo_gateway");
        public static final ResourceKey<PlacedFeature> SOLID_STATIC_ORE = Placed.of("solid_static_ore");
        public static final ResourceKey<PlacedFeature> DECAYED_BLOCK_ORE = Placed.of("decayed_block_ore");
        public static final ResourceKey<PlacedFeature> ETERNAL_FLUID_SPRING = Placed.of("eternal_fluid_spring");

        public static void init() {
        }

        public static ResourceKey<PlacedFeature> of(String id) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)DimensionalDoors.id(id));
        }

        @ExpectPlatform
        @ExpectPlatform.Transformed
        public static boolean isDesert(BiomeModifications.BiomeContext context) {
            return ModFeaturesPlacedImpl.isDesert(context);
        }

        @ExpectPlatform
        @ExpectPlatform.Transformed
        public static boolean isOcean(BiomeModifications.BiomeContext context) {
            return ModFeaturesPlacedImpl.isOcean(context);
        }

        @ExpectPlatform
        @ExpectPlatform.Transformed
        public static boolean isEnd(BiomeModifications.BiomeContext context) {
            return ModFeaturesPlacedImpl.isEnd(context);
        }

        @ExpectPlatform
        @ExpectPlatform.Transformed
        public static boolean isOverworld(BiomeModifications.BiomeContext context) {
            return ModFeaturesPlacedImpl.isOverworld(context);
        }
    }
}

