/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.feature.gateway.schematic;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.WorldGenLevel;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.BlockPlacementType;
import org.dimdev.dimdoors.pockets.TemplateUtils;
import org.dimdev.dimdoors.util.schematic.Schematic;
import org.dimdev.dimdoors.util.schematic.SchematicPlacer;
import org.dimdev.dimdoors.world.feature.gateway.Gateway;

public abstract class SchematicGateway
implements Gateway,
BiPredicate<WorldGenLevel, BlockPos> {
    private Schematic schematic;
    private final String id;
    public static final BiMap<String, SchematicGateway> ID_SCHEMATIC_MAP = HashBiMap.create();
    private boolean replaced;

    public SchematicGateway(String id) {
        ID_SCHEMATIC_MAP.putIfAbsent((Object)id, (Object)this);
        this.id = id;
    }

    public void init() {
        String schematicJarDirectory = "/data/dimdoors/gateways/";
        try (InputStream stream = DimensionalDoors.class.getResourceAsStream(schematicJarDirectory + this.id + ".schem");){
            if (stream == null) {
                throw new RuntimeException("Schematic '" + this.id + "' was not found in the jar.");
            }
            try {
                this.schematic = Schematic.fromNbt(NbtIo.m_128939_((InputStream)stream));
            }
            catch (IOException ex) {
                throw new RuntimeException("Schematic file for " + this.id + " could not be read as a valid schematic NBT file.", ex);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public final void generate(WorldGenLevel world, BlockPos pos) {
        if (DimensionalDoors.getConfig().getWorldConfig().gatewayDimBlacklist.contains(world.m_6018_().m_46472_().m_135782_().toString())) {
            return;
        }
        if (!this.replaced) {
            TemplateUtils.replacePlaceholders(this.schematic, world);
            this.replaced = true;
        }
        SchematicPlacer.place(this.schematic, world, pos, BlockPlacementType.SECTION_NO_UPDATE_QUEUE_BLOCK_ENTITY);
        this.generateRandomBits(world, pos);
    }

    protected void generateRandomBits(WorldGenLevel world, BlockPos pos) {
    }
}

