/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.level.component;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.chunk.LevelChunk;
import org.dimdev.dimdoors.world.level.component.forge.ChunkLazilyGeneratedComponentImpl;

public class ChunkLazilyGeneratedComponent {
    private boolean hasBeenLazyGenned = false;

    public boolean hasBeenLazyGenned() {
        return this.hasBeenLazyGenned;
    }

    public void setGenned() {
        if (this.hasBeenLazyGenned) {
            throw new UnsupportedOperationException("This chunk seems to have already been lazily generated!");
        }
        this.hasBeenLazyGenned = true;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ChunkLazilyGeneratedComponent get(LevelChunk chunk) {
        return ChunkLazilyGeneratedComponentImpl.get(chunk);
    }

    public void readFromNbt(CompoundTag nbt) {
        if (nbt.m_128425_("has_been_lazy_genned", 3)) {
            this.hasBeenLazyGenned = nbt.m_128451_("has_been_lazy_genned") == 1;
        }
    }

    public void writeToNbt(CompoundTag nbt) {
        if (this.hasBeenLazyGenned) {
            nbt.m_128405_("has_been_lazy_genned", 1);
        }
    }
}

