/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.math.GridUtil;
import org.dimdev.dimdoors.world.pocket.type.AbstractPocket;
import org.dimdev.dimdoors.world.pocket.type.IdReferencePocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.jetbrains.annotations.TestOnly;

public class PocketDirectory {
    int gridSize;
    int privatePocketSize;
    int publicPocketSize;
    Map<Integer, AbstractPocket<?>> pockets;
    private SortedMap<Integer, Integer> nextIDMap;
    ResourceKey<Level> worldKey;

    public PocketDirectory(ResourceKey<Level> worldKey) {
        this.gridSize = DimensionalDoors.getConfig().getPocketsConfig().pocketGridSize;
        this.worldKey = worldKey;
        this.nextIDMap = new TreeMap<Integer, Integer>();
        this.pockets = new HashMap();
    }

    @TestOnly
    public PocketDirectory(ResourceKey<Level> worldKey, int gridSize) {
        this.gridSize = gridSize;
        this.worldKey = worldKey;
        this.nextIDMap = new TreeMap<Integer, Integer>();
        this.pockets = new HashMap();
    }

    public static PocketDirectory readFromNbt(String id, CompoundTag nbt) {
        PocketDirectory directory = new PocketDirectory((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(id)));
        directory.gridSize = nbt.m_128451_("grid_size");
        directory.privatePocketSize = nbt.m_128451_("private_pocket_size");
        directory.publicPocketSize = nbt.m_128451_("public_pocket_size");
        CompoundTag nextIdMapNbt = nbt.m_128469_("next_id_map");
        directory.nextIDMap.putAll(nextIdMapNbt.m_128431_().stream().collect(Collectors.toMap(Integer::parseInt, arg_0 -> ((CompoundTag)nextIdMapNbt).m_128451_(arg_0))));
        CompoundTag pocketsNbt = nbt.m_128469_("pockets");
        directory.pockets = ((Stream)((Stream)pocketsNbt.m_128431_().stream().unordered()).map(key -> {
            CompoundTag pocketNbt = pocketsNbt.m_128469_(key);
            return CompletableFuture.supplyAsync(() -> new Pair((Object)Integer.parseInt(key), AbstractPocket.deserialize(pocketNbt)));
        }).parallel()).map(CompletableFuture::join).collect(Collectors.toConcurrentMap(Pair::getFirst, Pair::getSecond));
        return directory;
    }

    public CompoundTag writeToNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("grid_size", this.gridSize);
        nbt.m_128405_("private_pocket_size", this.privatePocketSize);
        nbt.m_128405_("public_pocket_size", this.publicPocketSize);
        CompoundTag nextIdMapNbt = new CompoundTag();
        this.nextIDMap.forEach((key, value) -> nextIdMapNbt.m_128405_(key.toString(), value.intValue()));
        nbt.m_128365_("next_id_map", (Tag)nextIdMapNbt);
        CompoundTag pocketsNbt = new CompoundTag();
        ((Stream)((Stream)this.pockets.entrySet().parallelStream().unordered()).map(entry -> CompletableFuture.supplyAsync(() -> new Pair((Object)((Integer)entry.getKey()).toString(), (Object)((AbstractPocket)entry.getValue()).toNbt(new CompoundTag())))).map(CompletableFuture::join).sequential()).forEach(pair -> pocketsNbt.m_128365_((String)pair.getFirst(), (Tag)pair.getSecond()));
        nbt.m_128365_("pockets", (Tag)pocketsNbt);
        return nbt;
    }

    public <T extends Pocket> T newPocket(Pocket.PocketBuilder<?, T> builder) {
        int base3Size;
        Vec3i size = builder.getExpectedSize();
        int longest = Math.max(Math.max(size.m_123341_(), size.m_123343_()), 1);
        longest = Math.floorDiv(longest - 1, this.gridSize * 16) + 1;
        for (base3Size = 1; longest > base3Size; base3Size *= 3) {
        }
        int squaredSize = base3Size * base3Size;
        int cursor = this.nextIDMap.headMap(base3Size + 1).values().stream().mapToInt(num -> num).max().orElse(0);
        cursor -= Math.floorMod(cursor, squaredSize);
        Pocket pocketAt = this.getPocket(cursor);
        while (pocketAt != null) {
            int pocketBase3Size;
            size = pocketAt.getSize();
            longest = Math.max(size.m_123341_(), size.m_123343_());
            longest = longest / (this.gridSize * 16) + 1;
            for (pocketBase3Size = 1; longest > pocketBase3Size; pocketBase3Size *= 3) {
            }
            pocketAt = this.getPocket(cursor += Math.max(squaredSize, pocketBase3Size * pocketBase3Size));
        }
        cursor = cursor + squaredSize - 1;
        AbstractPocket pocket = ((Pocket.PocketBuilder)((Pocket.PocketBuilder)((Pocket.PocketBuilder)((Pocket.PocketBuilder)builder.id(cursor)).world(this.worldKey)).range(squaredSize)).offsetOrigin((Vec3i)this.idToCenteredPos(cursor, base3Size, builder.getExpectedSize()))).build();
        this.nextIDMap.put(base3Size, cursor + squaredSize);
        this.addPocket(pocket);
        IdReferencePocket.IdReferencePocketBuilder idReferenceBuilder = IdReferencePocket.builder();
        for (int i = 1; i < squaredSize; ++i) {
            this.addPocket(((IdReferencePocket.IdReferencePocketBuilder)((IdReferencePocket.IdReferencePocketBuilder)idReferenceBuilder.id(cursor - i)).world(this.worldKey)).referencedId(cursor).build());
        }
        return (T)pocket;
    }

    private void addPocket(AbstractPocket<?> pocket) {
        this.pockets.put(pocket.getId(), pocket);
    }

    public void removePocket(int id) {
        this.pockets.remove(id);
    }

    public Pocket getPocket(int id) {
        AbstractPocket<?> pocket = this.pockets.get(id);
        return pocket == null ? null : pocket.getReferencedPocket(this);
    }

    public <P extends Pocket> P getPocket(int id, Class<P> clazz) {
        Pocket pocket = this.getPocket(id);
        if (clazz.isInstance(pocket)) {
            return (P)((Pocket)clazz.cast(pocket));
        }
        return null;
    }

    public GridUtil.GridPos idToGridPos(int id) {
        return GridUtil.idToGridPos(id);
    }

    public int gridPosToID(GridUtil.GridPos pos) {
        return GridUtil.gridPosToID(pos);
    }

    public BlockPos idToPos(int id) {
        GridUtil.GridPos pos = this.idToGridPos(id);
        return new BlockPos(pos.x * this.gridSize * 16, 0, pos.z * this.gridSize * 16);
    }

    public BlockPos idToCenteredPos(int id, int base3Size, Vec3i expectedSize) {
        GridUtil.GridPos pos = this.idToGridPos(id);
        return new BlockPos(pos.x * this.gridSize * 16 + (base3Size * this.gridSize - expectedSize.m_123341_() / 16) / 2 * 16, 0, pos.z * this.gridSize * 16 + (base3Size * this.gridSize - expectedSize.m_123343_() / 16) / 2 * 16);
    }

    public int posToID(BlockPos pos) {
        return this.gridPosToID(new GridUtil.GridPos(Math.floorDiv(pos.m_123341_(), this.gridSize * 16), Math.floorDiv(pos.m_123343_(), this.gridSize * 16)));
    }

    public Pocket getPocketAt(BlockPos pos) {
        return this.getPocket(this.posToID(pos));
    }

    public boolean isWithinPocketBounds(BlockPos pos) {
        Pocket pocket = this.getPocketAt(pos);
        return pocket != null && pocket.isInBounds(pos);
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public int getPrivatePocketSize() {
        return this.privatePocketSize;
    }

    public int getPublicPocketSize() {
        return this.publicPocketSize;
    }

    public Map<Integer, AbstractPocket<?>> getPockets() {
        return this.pockets;
    }
}

