/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket.type;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.VirtualLocation;
import org.dimdev.dimdoors.world.pocket.type.AbstractPocket;
import org.dimdev.dimdoors.world.pocket.type.addon.AddonProvider;
import org.dimdev.dimdoors.world.pocket.type.addon.PocketAddon;

public class Pocket
extends AbstractPocket<Pocket>
implements AddonProvider {
    public static String KEY = "pocket";
    private final Map<ResourceLocation, PocketAddon> addons = new HashMap<ResourceLocation, PocketAddon>();
    private int range = -1;
    private BoundingBox box;
    public VirtualLocation virtualLocation;

    public Pocket(int id, ResourceKey<Level> world, int x, int z) {
        super(id, world);
        int gridSize = DimensionalRegistry.getPocketDirectory(world).getGridSize() * 16;
        this.box = BoundingBox.m_162375_((Vec3i)new Vec3i(x * gridSize, 0, z * gridSize), (Vec3i)new Vec3i((x + 1) * gridSize, 0, (z + 1) * gridSize));
        this.virtualLocation = new VirtualLocation(world, x, z, 0);
    }

    protected Pocket() {
    }

    @Override
    public boolean hasAddon(ResourceLocation id) {
        return this.addons.containsKey(id);
    }

    @Override
    public <C extends PocketAddon> boolean addAddon(C addon) {
        if (addon.applicable(this)) {
            addon.addAddon(this.addons);
            return true;
        }
        return false;
    }

    @Override
    public <C extends PocketAddon> C getAddon(ResourceLocation id) {
        return (C)this.addons.get(id);
    }

    public <T> List<T> getAddonsInstanceOf(Class<T> clazz) {
        return this.addons.values().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public boolean isInBounds(BlockPos pos) {
        return this.box.m_71051_((Vec3i)pos);
    }

    public BlockPos getOrigin() {
        return new BlockPos(this.box.m_162395_(), this.box.m_162396_(), this.box.m_162398_());
    }

    public void offsetOrigin(Vec3i vec) {
        this.box.m_162373_(vec);
    }

    public void offsetOrigin(int x, int y, int z) {
        this.box.m_162367_(x, y, z);
    }

    public void setSize(Vec3i size) {
        this.setSize(size.m_123341_(), size.m_123342_(), size.m_123343_());
    }

    public void setSize(int x, int y, int z) {
        this.box = BoundingBox.m_162375_((Vec3i)new Vec3i(this.box.m_162395_(), this.box.m_162396_(), this.box.m_162398_()), (Vec3i)new Vec3i(this.box.m_162395_() + x - 1, this.box.m_162396_() + y - 1, this.box.m_162398_() + z - 1));
    }

    public void setRange(int range) {
        if (this.range > 0) {
            throw new UnsupportedOperationException("Cannot set range of Pocket that has already been initialized.");
        }
        this.range = range;
    }

    public int getRange() {
        if (this.range < 1) {
            throw new UnsupportedOperationException("Range of pocket has not been initialized yet.");
        }
        return this.range;
    }

    public Vec3i getSize() {
        return this.box.m_71053_();
    }

    @Override
    public CompoundTag toNbt(CompoundTag nbt) {
        super.toNbt(nbt);
        nbt.m_128405_("range", this.range);
        nbt.m_128385_("box", IntStream.of(this.box.m_162395_(), this.box.m_162396_(), this.box.m_162398_(), this.box.m_162399_(), this.box.m_162400_(), this.box.m_162401_()).toArray());
        nbt.m_128365_("virtualLocation", (Tag)VirtualLocation.toNbt(this.virtualLocation));
        ListTag addonsTag = new ListTag();
        addonsTag.addAll((Collection)this.addons.values().stream().map(addon -> addon.toNbt(new CompoundTag())).collect(Collectors.toList()));
        if (addonsTag.size() > 0) {
            nbt.m_128365_("addons", (Tag)addonsTag);
        }
        return nbt;
    }

    @Override
    public AbstractPocket.AbstractPocketType<?> getType() {
        return (AbstractPocket.AbstractPocketType)AbstractPocket.AbstractPocketType.POCKET.get();
    }

    @Override
    public Pocket fromNbt(CompoundTag nbt) {
        super.fromNbt(nbt);
        this.range = nbt.m_128451_("range");
        int[] box = nbt.m_128465_("box");
        this.box = BoundingBox.m_162375_((Vec3i)new Vec3i(box[0], box[1], box[2]), (Vec3i)new Vec3i(box[3], box[4], box[5]));
        this.virtualLocation = VirtualLocation.fromNbt(nbt.m_128469_("virtualLocation"));
        if (nbt.m_128425_("addons", 9)) {
            for (Tag addonTag : nbt.m_128437_("addons", 10)) {
                PocketAddon addon = PocketAddon.deserialize((CompoundTag)addonTag);
                this.addons.put(addon.getId(), addon);
            }
        }
        return this;
    }

    public Map<BlockPos, BlockEntity> getBlockEntities() {
        ServerLevel serverWorld = DimensionalDoors.getWorld(this.getWorld());
        HashMap<BlockPos, BlockEntity> blockEntities = new HashMap<BlockPos, BlockEntity>();
        ChunkPos.m_45599_((ChunkPos)new ChunkPos(new BlockPos(this.box.m_162395_(), this.box.m_162396_(), this.box.m_162396_())), (ChunkPos)new ChunkPos(new BlockPos(this.box.m_162399_(), this.box.m_162400_(), this.box.m_162401_()))).forEach(arg_0 -> this.lambda$getBlockEntities$2((Level)serverWorld, blockEntities, arg_0));
        return blockEntities;
    }

    public BoundingBox getBox() {
        return this.box;
    }

    @Override
    public Map<String, Double> toVariableMap(Map<String, Double> variableMap) {
        variableMap = super.toVariableMap(variableMap);
        variableMap.put("originX", Double.valueOf(this.box.m_162395_()));
        variableMap.put("originY", Double.valueOf(this.box.m_162396_()));
        variableMap.put("originZ", Double.valueOf(this.box.m_162398_()));
        variableMap.put("width", Double.valueOf(this.box.m_71053_().m_123341_()));
        variableMap.put("height", Double.valueOf(this.box.m_71053_().m_123342_()));
        variableMap.put("length", Double.valueOf(this.box.m_71053_().m_123343_()));
        variableMap.put("depth", Double.valueOf(this.virtualLocation.getDepth()));
        return variableMap;
    }

    @Override
    public Pocket getReferencedPocket() {
        return this;
    }

    public void expand(int amount) {
        this.box.m_191961_(amount);
    }

    public static PocketBuilder<?, Pocket> builder() {
        return new PocketBuilder((AbstractPocket.AbstractPocketType)AbstractPocket.AbstractPocketType.POCKET.get());
    }

    protected void setBox(BoundingBox box) {
        this.box = box;
    }

    private /* synthetic */ void lambda$getBlockEntities$2(Level serverWorld, Map blockEntities, ChunkPos chunkPos) {
        serverWorld.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_).m_62954_().forEach((blockPos, blockEntity) -> {
            if (this.box.m_71051_((Vec3i)blockPos)) {
                blockEntities.put(blockPos, blockEntity);
            }
        });
    }

    public static class PocketBuilder<P extends PocketBuilder<P, T>, T extends Pocket>
    extends AbstractPocket.AbstractPocketBuilder<P, T> {
        private final Map<ResourceLocation, PocketAddon.PocketBuilderAddon<?>> addons = new HashMap();
        private Vec3i origin = new Vec3i(0, 0, 0);
        private Vec3i size = new Vec3i(0, 0, 0);
        private Vec3i expected = new Vec3i(0, 0, 0);
        private VirtualLocation virtualLocation;
        private int range = -1;

        protected PocketBuilder(AbstractPocket.AbstractPocketType<T> type) {
            super(type);
            this.initAddons();
        }

        public void initAddons() {
        }

        @Override
        public P fromNbt(CompoundTag nbt) {
            if (nbt.m_128425_("addons", 9)) {
                for (Tag addonTag : nbt.m_128437_("addons", 10)) {
                    PocketAddon.PocketBuilderAddon<?> addon = PocketAddon.deserializeBuilder((CompoundTag)addonTag);
                    this.addons.put(addon.getId(), addon);
                }
            }
            return (P)((PocketBuilder)this.getSelf());
        }

        @Override
        public CompoundTag toNbt(CompoundTag nbt) {
            ListTag addonsTag = new ListTag();
            addonsTag.addAll((Collection)this.addons.values().stream().map(addon -> addon.toNbt(new CompoundTag())).collect(Collectors.toList()));
            if (addonsTag.size() > 0) {
                nbt.m_128365_("addons", (Tag)addonsTag);
            }
            return nbt;
        }

        public boolean hasAddon(ResourceLocation id) {
            return this.addons.containsKey(id);
        }

        protected <C extends PocketAddon.PocketBuilderAddon<?>> boolean addAddon(C addon) {
            if (addon.applicable(this)) {
                addon.addAddon(this.addons);
                return true;
            }
            return false;
        }

        public <C extends PocketAddon.PocketBuilderAddon<?>> C getAddon(ResourceLocation id) {
            return (C)this.addons.get(id);
        }

        @Override
        public Vec3i getExpectedSize() {
            return this.expected;
        }

        @Override
        public T build() {
            if (this.range < 1) {
                throw new RuntimeException("Cannot create pocket with range < 1");
            }
            Pocket instance = (Pocket)super.build();
            instance.setRange(this.range);
            instance.setBox(BoundingBox.m_162375_((Vec3i)new Vec3i(this.origin.m_123341_(), this.origin.m_123342_(), this.origin.m_123343_()), (Vec3i)new Vec3i(this.origin.m_123341_() + this.size.m_123341_(), this.origin.m_123342_() + this.size.m_123342_(), this.origin.m_123343_() + this.size.m_123343_())));
            instance.virtualLocation = this.virtualLocation;
            this.addons.values().forEach(addon -> addon.apply(instance));
            return (T)instance;
        }

        public P offsetOrigin(Vec3i offset) {
            this.origin = new Vec3i(this.origin.m_123341_() + offset.m_123341_(), this.origin.m_123342_() + offset.m_123342_(), this.origin.m_123343_() + offset.m_123343_());
            return (P)((PocketBuilder)this.getSelf());
        }

        public P expand(Vec3i expander) {
            this.size = new Vec3i(this.size.m_123341_() + expander.m_123341_(), this.size.m_123342_() + expander.m_123342_(), this.size.m_123343_() + expander.m_123343_());
            this.expected = new Vec3i(this.expected.m_123341_() + expander.m_123341_(), this.expected.m_123342_() + expander.m_123342_(), this.expected.m_123343_() + expander.m_123343_());
            return (P)((PocketBuilder)this.getSelf());
        }

        public P expandExpected(Vec3i expander) {
            this.expected = new Vec3i(this.expected.m_123341_() + expander.m_123341_(), this.expected.m_123342_() + expander.m_123342_(), this.expected.m_123343_() + expander.m_123343_());
            return (P)((PocketBuilder)this.getSelf());
        }

        public P virtualLocation(VirtualLocation virtualLocation) {
            this.virtualLocation = virtualLocation;
            return (P)((PocketBuilder)this.getSelf());
        }

        public P range(int range) {
            this.range = range;
            return (P)((PocketBuilder)this.getSelf());
        }
    }
}

