/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket.type.addon;

import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.addon.AddonProvider;
import org.dimdev.dimdoors.world.pocket.type.addon.AutoSyncedAddon;
import org.dimdev.dimdoors.world.pocket.type.addon.PocketAddon;

public class SkyAddon
implements AutoSyncedAddon {
    public static ResourceLocation ID = DimensionalDoors.id("sky");
    private ResourceKey<Level> world;

    public boolean setWorld(ResourceKey<Level> world) {
        this.world = world;
        return true;
    }

    @Override
    public PocketAddon fromNbt(CompoundTag nbt) {
        this.world = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)nbt.m_128461_("world")));
        return this;
    }

    @Override
    public CompoundTag toNbt(CompoundTag nbt) {
        AutoSyncedAddon.super.toNbt(nbt);
        nbt.m_128359_("world", this.world.m_135782_().toString());
        return nbt;
    }

    @Override
    public PocketAddon.PocketAddonType<? extends PocketAddon> getType() {
        return (PocketAddon.PocketAddonType)PocketAddon.PocketAddonType.SKY_ADDON.get();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public ResourceKey<Level> getWorld() {
        return this.world;
    }

    @Override
    public AutoSyncedAddon read(FriendlyByteBuf buf) {
        this.world = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buf.m_130281_());
        return this;
    }

    @Override
    public FriendlyByteBuf write(FriendlyByteBuf buf) {
        buf.m_130085_(this.world.m_135782_());
        return buf;
    }

    public static interface SkyPocket
    extends AddonProvider {
        default public boolean sky(ResourceKey<Level> world) {
            this.ensureIsPocket();
            if (!this.hasAddon(ID)) {
                SkyAddon addon = new SkyAddon();
                this.addAddon(addon);
                return addon.setWorld(world);
            }
            return ((SkyAddon)this.getAddon(ID)).setWorld(world);
        }
    }

    public static class SkyBuilderAddon
    implements PocketAddon.PocketBuilderAddon<SkyAddon> {
        private ResourceKey<Level> world = Level.f_46428_;

        @Override
        public void apply(Pocket pocket) {
            SkyAddon addon = new SkyAddon();
            addon.world = this.world;
            pocket.addAddon(addon);
        }

        @Override
        public ResourceLocation getId() {
            return ID;
        }

        @Override
        public PocketAddon.PocketBuilderAddon<SkyAddon> fromNbt(CompoundTag nbt) {
            this.world = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)nbt.m_128461_("world")));
            return this;
        }

        @Override
        public CompoundTag toNbt(CompoundTag nbt) {
            PocketAddon.PocketBuilderAddon.super.toNbt(nbt);
            nbt.m_128359_("world", this.world.m_135782_().toString());
            return nbt;
        }

        @Override
        public PocketAddon.PocketAddonType<SkyAddon> getType() {
            return (PocketAddon.PocketAddonType)PocketAddon.PocketAddonType.SKY_ADDON.get();
        }
    }

    public static interface SkyPocketBuilder<T extends Pocket.PocketBuilder<T, ?>>
    extends PocketAddon.PocketBuilderExtension<T> {
        default public T world(ResourceKey<Level> world) {
            ((SkyBuilderAddon)this.getAddon((ResourceLocation)SkyAddon.ID)).world = world;
            return this.getSelf();
        }
    }
}

