/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.Bindings;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DataPackRegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import twilightforest.TFConfig;
import twilightforest.advancements.TFAdvancements;
import twilightforest.capabilities.CapabilityList;
import twilightforest.client.ClientInitiator;
import twilightforest.command.TFCommand;
import twilightforest.compat.curios.CuriosCompat;
import twilightforest.compat.top.TopCompat;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.dispenser.TFDispenserBehaviors;
import twilightforest.init.TFBannerPatterns;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEnchantments;
import twilightforest.init.TFEntities;
import twilightforest.init.TFFeatureModifiers;
import twilightforest.init.TFFeatures;
import twilightforest.init.TFItems;
import twilightforest.init.TFLoot;
import twilightforest.init.TFLootModifiers;
import twilightforest.init.TFMenuTypes;
import twilightforest.init.TFMobEffects;
import twilightforest.init.TFPOITypes;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFRecipes;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStats;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.init.TFStructurePlacementTypes;
import twilightforest.init.TFStructureProcessors;
import twilightforest.init.TFStructureTypes;
import twilightforest.init.custom.BiomeLayerStack;
import twilightforest.init.custom.BiomeLayerTypes;
import twilightforest.init.custom.DwarfRabbitVariant;
import twilightforest.init.custom.TinyBirdVariant;
import twilightforest.init.custom.WoodPalettes;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.WoodPalette;
import twilightforest.world.components.BiomeGrassColors;
import twilightforest.world.components.biomesources.LandmarkBiomeSource;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;

@Mod(value="twilightforest")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TwilightForestMod {
    public static final String ID = "twilightforest";
    public static final String REGISTRY_NAMESPACE = "twilight";
    private static final String MODEL_DIR = "textures/model/";
    private static final String GUI_DIR = "textures/gui/";
    private static final String ENVIRO_DIR = "textures/environment/";
    public static final String ARMOR_DIR = "twilightforest:textures/armor/";
    public static final GameRules.Key<GameRules.BooleanValue> ENFORCED_PROGRESSION_RULE = GameRules.m_46189_((String)"tfEnforcedProgression", (GameRules.Category)GameRules.Category.UPDATES, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final Logger LOGGER = LogManager.getLogger((String)"twilightforest");
    private static final Rarity rarity = Rarity.create((String)"TWILIGHT", (ChatFormatting)ChatFormatting.DARK_GREEN);

    public TwilightForestMod() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(TFConfig.Common::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)specPair.getRight());
        TFConfig.COMMON_CONFIG = (TFConfig.Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(TFConfig.Client::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)specPair.getRight());
        TFConfig.CLIENT_CONFIG = (TFConfig.Client)specPair.getLeft();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientInitiator::call);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, CapabilityList::attachLevelCapability);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, CapabilityList::attachEntityCapability);
        MinecraftForge.EVENT_BUS.addListener(Stalactite::reloadStalactites);
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        TFBannerPatterns.BANNER_PATTERNS.register(modbus);
        TFBlockEntities.BLOCK_ENTITIES.register(modbus);
        TFBlocks.BLOCKS.register(modbus);
        TFLoot.CONDITIONS.register(modbus);
        TFMenuTypes.CONTAINERS.register(modbus);
        TFEnchantments.ENCHANTMENTS.register(modbus);
        TFEntities.ENTITIES.register(modbus);
        BiomeLayerTypes.BIOME_LAYER_TYPES.register(modbus);
        BiomeLayerStack.BIOME_LAYER_STACKS.register(modbus);
        TFFeatures.FEATURES.register(modbus);
        TFFeatureModifiers.FOLIAGE_PLACERS.register(modbus);
        TFLoot.FUNCTIONS.register(modbus);
        TFItems.ITEMS.register(modbus);
        TFLootModifiers.LOOT_MODIFIERS.register(modbus);
        TFMobEffects.MOB_EFFECTS.register(modbus);
        TFParticleType.PARTICLE_TYPES.register(modbus);
        TFPOITypes.POIS.register(modbus);
        TFFeatureModifiers.PLACEMENT_MODIFIERS.register(modbus);
        TFRecipes.RECIPE_SERIALIZERS.register(modbus);
        TFRecipes.RECIPE_TYPES.register(modbus);
        TFSounds.SOUNDS.register(modbus);
        TFEntities.SPAWN_EGGS.register(modbus);
        TFStats.STATS.register(modbus);
        TFStructurePieceTypes.STRUCTURE_PIECE_TYPES.register(modbus);
        TFStructureProcessors.STRUCTURE_PROCESSORS.register(modbus);
        TFStructurePlacementTypes.STRUCTURE_PLACEMENT_TYPES.register(modbus);
        TFStructureTypes.STRUCTURE_TYPES.register(modbus);
        TFFeatureModifiers.TREE_DECORATORS.register(modbus);
        TFFeatureModifiers.TRUNK_PLACERS.register(modbus);
        DwarfRabbitVariant.DWARF_RABBITS.register(modbus);
        TinyBirdVariant.TINY_BIRDS.register(modbus);
        WoodPalettes.WOOD_PALETTES.register(modbus);
        modbus.addListener(this::sendIMCs);
        modbus.addListener(CapabilityList::registerCapabilities);
        if (ModList.get().isLoaded("curios")) {
            ((IEventBus)Bindings.getForgeBus().get()).addListener(CuriosCompat::keepCurios);
        }
        BiomeGrassColors.init();
    }

    @SubscribeEvent
    public static void setRegistriesForDatapack(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(WoodPalettes.WOOD_PALETTE_TYPE_KEY, WoodPalette.CODEC);
        event.dataPackRegistry(BiomeLayerStack.BIOME_STACK_KEY, BiomeLayerStack.DISPATCH_CODEC);
    }

    @SubscribeEvent
    public static void addClassicPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById(ID).getFile().findResource(new String[]{"classic"});
            Pack pack = Pack.m_245429_((String)"builtin/twilight_forest_classic_resources", (Component)Component.m_237113_((String)"Twilight Classic"), (boolean)false, path -> new PathPackResources(path, resourcePath, true), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
    }

    @SubscribeEvent
    public static void registerSerializers(RegisterEvent evt) {
        if (Objects.equals(evt.getForgeRegistry(), ForgeRegistries.RECIPE_SERIALIZERS)) {
            Registry.m_122965_((Registry)BuiltInRegistries.f_256737_, (ResourceLocation)TwilightForestMod.prefix("twilight_biomes"), TFBiomeProvider.TF_CODEC);
            Registry.m_122965_((Registry)BuiltInRegistries.f_256737_, (ResourceLocation)TwilightForestMod.prefix("landmarks"), LandmarkBiomeSource.CODEC);
            Registry.m_122965_((Registry)BuiltInRegistries.f_256914_, (ResourceLocation)TwilightForestMod.prefix("structure_locating_wrapper"), ChunkGeneratorTwilight.CODEC);
        }
    }

    public void sendIMCs(InterModEnqueueEvent evt) {
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.handleCuriosIMCs();
        }
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TopCompat::new);
        }
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent evt) {
        TFPacketHandler.init();
        TFAdvancements.init();
        evt.enqueueWork(() -> {
            TFBlocks.tfCompostables();
            TFBlocks.tfBurnables();
            TFBlocks.tfPots();
            TFSounds.registerParrotSounds();
            TFDispenserBehaviors.init();
            TFStats.init();
            CauldronInteraction.f_175607_.put((Item)TFItems.ARCTIC_HELMET.get(), CauldronInteraction.f_175615_);
            CauldronInteraction.f_175607_.put((Item)TFItems.ARCTIC_CHESTPLATE.get(), CauldronInteraction.f_175615_);
            CauldronInteraction.f_175607_.put((Item)TFItems.ARCTIC_LEGGINGS.get(), CauldronInteraction.f_175615_);
            CauldronInteraction.f_175607_.put((Item)TFItems.ARCTIC_BOOTS.get(), CauldronInteraction.f_175615_);
            AxeItem.f_150683_ = Maps.newHashMap((Map)AxeItem.f_150683_);
            AxeItem.f_150683_.put((Block)TFBlocks.TWILIGHT_OAK_LOG.get(), (Block)TFBlocks.STRIPPED_TWILIGHT_OAK_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.CANOPY_LOG.get(), (Block)TFBlocks.STRIPPED_CANOPY_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.MANGROVE_LOG.get(), (Block)TFBlocks.STRIPPED_MANGROVE_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.DARK_LOG.get(), (Block)TFBlocks.STRIPPED_DARK_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TIME_LOG.get(), (Block)TFBlocks.STRIPPED_TIME_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TRANSFORMATION_LOG.get(), (Block)TFBlocks.STRIPPED_TRANSFORMATION_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.MINING_LOG.get(), (Block)TFBlocks.STRIPPED_MINING_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.SORTING_LOG.get(), (Block)TFBlocks.STRIPPED_SORTING_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TWILIGHT_OAK_WOOD.get(), (Block)TFBlocks.STRIPPED_TWILIGHT_OAK_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.CANOPY_WOOD.get(), (Block)TFBlocks.STRIPPED_CANOPY_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.MANGROVE_WOOD.get(), (Block)TFBlocks.STRIPPED_MANGROVE_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.DARK_WOOD.get(), (Block)TFBlocks.STRIPPED_DARK_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TIME_WOOD.get(), (Block)TFBlocks.STRIPPED_TIME_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TRANSFORMATION_WOOD.get(), (Block)TFBlocks.STRIPPED_TRANSFORMATION_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.MINING_WOOD.get(), (Block)TFBlocks.STRIPPED_MINING_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.SORTING_WOOD.get(), (Block)TFBlocks.STRIPPED_SORTING_WOOD.get());
        });
    }

    public void registerCommands(RegisterCommandsEvent event) {
        TFCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation(ID, name.toLowerCase(Locale.ROOT));
    }

    public static ResourceLocation namedRegistry(String name) {
        return new ResourceLocation(REGISTRY_NAMESPACE, name.toLowerCase(Locale.ROOT));
    }

    public static ResourceLocation getModelTexture(String name) {
        return new ResourceLocation(ID, MODEL_DIR + name);
    }

    public static ResourceLocation getGuiTexture(String name) {
        return new ResourceLocation(ID, GUI_DIR + name);
    }

    public static ResourceLocation getEnvTexture(String name) {
        return new ResourceLocation(ID, ENVIRO_DIR + name);
    }

    public static Rarity getRarity() {
        return rarity;
    }
}

