/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.advancements;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;

public class KillBugTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = TwilightForestMod.prefix("kill_bug");

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected Instance createInstance(JsonObject json, EntityPredicate.Composite player, DeserializationContext ctx) {
        Block bug = KillBugTrigger.deserializeBug(json);
        return new Instance(player, bug);
    }

    @Nullable
    private static Block deserializeBug(JsonObject object) {
        if (object.has("bug")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"bug"));
            return (Block)ForgeRegistries.BLOCKS.getValue(resourcelocation);
        }
        return null;
    }

    public void trigger(ServerPlayer player, BlockState bug) {
        this.m_66234_(player, instance -> instance.matches(bug));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final Block bugType;

        public Instance(EntityPredicate.Composite player, @Nullable Block bugType) {
            super(ID, player);
            this.bugType = bugType;
        }

        public static Instance killBug(Block bug) {
            return new Instance(EntityPredicate.Composite.f_36667_, bug);
        }

        public boolean matches(BlockState bug) {
            return this.bugType == null || bug.m_60713_(this.bugType);
        }

        public JsonObject m_7683_(SerializationContext ctx) {
            JsonObject object = super.m_7683_(ctx);
            if (this.bugType != null) {
                object.addProperty("bug", ForgeRegistries.BLOCKS.getKey((Object)this.bugType).toString());
            }
            return object;
        }
    }
}

