/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.WaterloggedBlock;
import twilightforest.enums.HollowLogVariants;
import twilightforest.init.TFBlocks;
import twilightforest.util.AxisUtil;

public class HollowLogHorizontal
extends Block
implements WaterloggedBlock {
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.f_61364_;
    public static final EnumProperty<HollowLogVariants.Horizontal> VARIANT = EnumProperty.m_61587_((String)"variant", HollowLogVariants.Horizontal.class);
    private static final VoxelShape HOLLOW_SHAPE_X = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape HOLLOW_SHAPE_Z = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape CARPET_SHAPE_X = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape CARPET_SHAPE_Z = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape COLLISION_SHAPE_X = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape COLLISION_SHAPE_Z = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0), (BooleanOp)BooleanOp.f_82685_);

    public HollowLogHorizontal(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).m_61124_(VARIANT, (Comparable)((Object)HollowLogVariants.Horizontal.EMPTY)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((HollowLogVariants.Horizontal)((Object)state.m_61143_(VARIANT))) {
            default -> throw new IncompatibleClassChangeError();
            case HollowLogVariants.Horizontal.EMPTY, HollowLogVariants.Horizontal.WATERLOGGED -> {
                switch ((Direction.Axis)state.m_61143_(HORIZONTAL_AXIS)) {
                    case X: {
                        yield HOLLOW_SHAPE_X;
                    }
                    case Z: {
                        yield HOLLOW_SHAPE_Z;
                    }
                }
                yield Shapes.m_83144_();
            }
            case HollowLogVariants.Horizontal.MOSS, HollowLogVariants.Horizontal.MOSS_AND_GRASS, HollowLogVariants.Horizontal.SNOW -> {
                switch ((Direction.Axis)state.m_61143_(HORIZONTAL_AXIS)) {
                    case X: {
                        yield CARPET_SHAPE_X;
                    }
                    case Z: {
                        yield CARPET_SHAPE_Z;
                    }
                }
                yield Shapes.m_83144_();
            }
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.m_61143_(HORIZONTAL_AXIS)) {
            case Direction.Axis.X -> COLLISION_SHAPE_X;
            case Direction.Axis.Z -> COLLISION_SHAPE_Z;
            default -> Shapes.m_83040_();
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{HORIZONTAL_AXIS, VARIANT}));
    }

    @Override
    public boolean isStateWaterlogged(BlockState state) {
        return state.m_61143_(VARIANT) == HollowLogVariants.Horizontal.WATERLOGGED;
    }

    @Override
    public BlockState setWaterlog(BlockState prior, boolean doWater) {
        return (BlockState)prior.m_61124_(VARIANT, (Comparable)((Object)(doWater ? HollowLogVariants.Horizontal.WATERLOGGED : HollowLogVariants.Horizontal.EMPTY)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_(HORIZONTAL_AXIS, (Comparable)context.m_43719_().m_122434_())).m_61124_(VARIANT, (Comparable)((Object)(context.m_43725_().m_8055_(context.m_8083_()).m_60819_().m_76152_() == Fluids.f_76193_ ? HollowLogVariants.Horizontal.WATERLOGGED : HollowLogVariants.Horizontal.EMPTY)));
    }

    public FluidState m_5888_(BlockState state) {
        return state.m_61143_(VARIANT) == HollowLogVariants.Horizontal.WATERLOGGED ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (this.isStateWaterlogged(state)) {
            accessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        return super.m_7417_(state, facing, neighborState, accessor, pos, neighborPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction.Axis stateAxis = (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
        if (!HollowLogHorizontal.isInside((HitResult)hit, stateAxis, pos)) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        ItemStack stack = player.m_21120_(hand);
        HollowLogVariants.Horizontal variant = (HollowLogVariants.Horizontal)((Object)state.m_61143_(VARIANT));
        if (stack.m_150930_(((Block)TFBlocks.MOSS_PATCH.get()).m_5456_())) {
            if (HollowLogHorizontal.canChangeVariant(variant, level, pos, stateAxis)) {
                level.m_7731_(pos, (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)HollowLogVariants.Horizontal.MOSS)), 3);
                level.m_5594_(null, pos, SoundEvents.f_144190_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        } else if (stack.m_150930_(Blocks.f_50034_.m_5456_())) {
            if (variant == HollowLogVariants.Horizontal.MOSS) {
                level.m_7731_(pos, (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)HollowLogVariants.Horizontal.MOSS_AND_GRASS)), 3);
                level.m_5594_(null, pos, SoundEvents.f_11991_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        } else if (stack.m_150930_(Items.f_42452_)) {
            if (HollowLogHorizontal.canChangeVariant(variant, level, pos, stateAxis)) {
                level.m_7731_(pos, (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)HollowLogVariants.Horizontal.SNOW)), 3);
                level.m_5594_(null, pos, SoundEvents.f_12482_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        } else if (stack.canPerformAction(ToolActions.SHOVEL_DIG)) {
            if (variant == HollowLogVariants.Horizontal.SNOW) {
                level.m_7731_(pos, (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)HollowLogVariants.Horizontal.EMPTY)), 3);
                level.m_5594_(null, pos, SoundEvents.f_12474_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)Items.f_42452_)));
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        } else if (stack.canPerformAction(ToolActions.SHEARS_HARVEST) && (variant == HollowLogVariants.Horizontal.MOSS || variant == HollowLogVariants.Horizontal.MOSS_AND_GRASS)) {
            level.m_7731_(pos, (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)HollowLogVariants.Horizontal.EMPTY)), 3);
            level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)TFBlocks.MOSS_PATCH.get())));
                if (variant == HollowLogVariants.Horizontal.MOSS_AND_GRASS) {
                    level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)Blocks.f_50034_)));
                }
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    private static boolean canChangeVariant(HollowLogVariants.Horizontal variant, Level level, BlockPos pos, Direction.Axis axis) {
        return variant == HollowLogVariants.Horizontal.EMPTY || variant == HollowLogVariants.Horizontal.WATERLOGGED && level.m_6425_(pos.m_121945_(AxisUtil.getAxisDirectionNegative(axis))).m_76152_() != Fluids.f_76193_ && level.m_6425_(pos.m_121945_(AxisUtil.getAxisDirectionPositive(axis))).m_76152_() != Fluids.f_76193_;
    }

    private static boolean isInside(HitResult result, Direction.Axis axis, BlockPos pos) {
        Vec3 vec = result.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (0.124 > vec.f_82480_ || vec.f_82480_ > 0.876) {
            return false;
        }
        return switch (axis) {
            case Direction.Axis.X -> {
                if (0.124 <= vec.f_82481_ && vec.f_82481_ <= 0.876) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> {
                if (0.124 <= vec.f_82479_ && vec.f_82479_ <= 0.876) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }
}

