/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import twilightforest.block.LockedVanishingBlock;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;

public class VanishingBlock
extends Block {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty VANISHED = BooleanProperty.m_61465_((String)"vanished");
    private static final VoxelShape VANISHED_SHAPE = VanishingBlock.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);

    public VanishingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE});
    }

    private boolean isVanished(BlockState state) {
        return state.m_61138_((Property)VANISHED) && (Boolean)state.m_61143_((Property)VANISHED) != false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return this.isVanished(state) ? VANISHED_SHAPE : super.m_5940_(state, getter, pos, ctx);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return this.isVanished(state) ? Shapes.m_83040_() : super.m_5939_(state, getter, pos, ctx);
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.isVanished(state) && !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            if (VanishingBlock.areBlocksLocked((BlockGetter)level, pos)) {
                level.m_5594_(null, pos, (SoundEvent)TFSounds.LOCKED_VANISHING_BLOCK.get(), SoundSource.BLOCKS, 1.0f, 0.3f);
            } else {
                this.activate(level, pos);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public float getExplosionResistance(BlockState state, BlockGetter getter, BlockPos pos, Explosion explosion) {
        return (Boolean)state.m_61143_((Property)ACTIVE) == false ? 6000.0f : super.getExplosionResistance(state, getter, pos, explosion);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter getter, BlockPos pos, Entity entity) {
        return !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() ? !VanishingBlock.areBlocksLocked(getter, pos) : super.canEntityDestroy(state, getter, pos, entity);
    }

    private static boolean areBlocksLocked(BlockGetter getter, BlockPos start) {
        int limit = 512;
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        queue.offer(start);
        for (int iter = 0; !queue.isEmpty() && iter < limit; ++iter) {
            BlockPos cur = (BlockPos)queue.pop();
            BlockState state = getter.m_8055_(cur);
            if (state.m_60734_() == TFBlocks.LOCKED_VANISHING_BLOCK.get() && ((Boolean)state.m_61143_((Property)LockedVanishingBlock.LOCKED)).booleanValue()) {
                return true;
            }
            checked.add(cur);
            if (!(state.m_60734_() instanceof VanishingBlock)) continue;
            for (Direction facing : Direction.values()) {
                BlockPos neighbor = cur.m_121945_(facing);
                if (checked.contains(neighbor)) continue;
                queue.offer(neighbor);
            }
        }
        return false;
    }

    @Deprecated
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        if (!this.isVanished(state) && !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && level.m_46753_(pos) && !VanishingBlock.areBlocksLocked((BlockGetter)level, pos)) {
            this.activate(level, pos);
        }
    }

    @Deprecated
    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_5776_()) {
            return;
        }
        if (this.isVanished(state)) {
            if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)VANISHED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            } else {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
                level.m_186460_(pos, (Block)this, 15);
            }
            level.m_5594_(null, pos, (SoundEvent)TFSounds.REAPPEAR_BLOCK.get(), SoundSource.BLOCKS, 0.3f, 0.6f);
        } else if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            if (state.m_61138_((Property)VANISHED)) {
                level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VANISHED, (Comparable)Boolean.valueOf(true)));
                level.m_186460_(pos, (Block)this, 80);
            } else {
                level.m_7471_(pos, false);
            }
            level.m_5594_(null, pos, state.m_60734_() == TFBlocks.REAPPEARING_BLOCK.get() ? (SoundEvent)TFSounds.REAPPEAR_POOF.get() : (SoundEvent)TFSounds.VANISHING_BLOCK.get(), SoundSource.BLOCKS, 0.3f, 0.5f);
            for (Direction e : Direction.values()) {
                this.activate((Level)level, pos.m_121945_(e));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            this.sparkle(level, pos);
        }
    }

    public void sparkle(Level level, BlockPos pos) {
        RandomSource random = level.m_213780_();
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.m_123341_() + random.m_188501_();
            double d2 = (float)pos.m_123342_() + random.m_188501_();
            double d3 = (float)pos.m_123343_() + random.m_188501_();
            if (i == 0 && !level.m_8055_(pos.m_7494_()).m_60804_((BlockGetter)level, pos)) {
                d2 = (double)pos.m_123342_() + d0 + 1.0;
            }
            if (i == 1 && !level.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)level, pos)) {
                d2 = (double)pos.m_123342_() - d0;
            }
            if (i == 2 && !level.m_8055_(pos.m_122019_()).m_60804_((BlockGetter)level, pos)) {
                d3 = (double)pos.m_123343_() + d0 + 1.0;
            }
            if (i == 3 && !level.m_8055_(pos.m_122012_()).m_60804_((BlockGetter)level, pos)) {
                d3 = (double)pos.m_123343_() - d0;
            }
            if (i == 4 && !level.m_8055_(pos.m_122029_()).m_60804_((BlockGetter)level, pos)) {
                d1 = (double)pos.m_123341_() + d0 + 1.0;
            }
            if (i == 5 && !level.m_8055_(pos.m_122024_()).m_60804_((BlockGetter)level, pos)) {
                d1 = (double)pos.m_123341_() - d0;
            }
            float f1 = 1.0f;
            float f2 = Math.max(0.0f, 0.19999999f);
            float f3 = Math.max(0.0f, -0.099999964f);
            if (!(d1 < (double)pos.m_123341_() || d1 > (double)(pos.m_123341_() + 1) || d2 < 0.0 || d2 > (double)(pos.m_123342_() + 1) || d3 < (double)pos.m_123343_()) && !(d3 > (double)(pos.m_123343_() + 1))) continue;
            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(f1, f2, f3), 1.0f), d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    private void activate(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof VanishingBlock && !this.isVanished(state) && !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            level.m_186460_(pos, state.m_60734_(), 2 + level.m_213780_().m_188503_(5));
        }
    }
}

