/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.entity.passive.QuestRam;

@Mod.EventBusSubscriber(modid="twilightforest", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class TFOverlays {
    private static final ResourceLocation TF_ICONS_SHEET = TwilightForestMod.prefix("textures/gui/tf_icons.png");

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "quest_ram_indicator", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null && !minecraft.f_91066_.f_92062_ && ((Boolean)TFConfig.CLIENT_CONFIG.showQuestRamCrosshairIndicator.get()).booleanValue()) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)TF_ICONS_SHEET);
                RenderSystem.m_69478_();
                TFOverlays.renderIndicator(minecraft, poseStack, (Gui)gui, (Player)player, screenWidth, screenHeight);
                RenderSystem.m_69461_();
            }
        });
    }

    public static void renderIndicator(Minecraft minecraft, PoseStack poseStack, Gui gui, Player player, int screenWidth, int screenHeight) {
        Options options = minecraft.f_91066_;
        if (options.m_92176_().m_90612_() && (minecraft.f_91072_.m_105295_() != GameType.SPECTATOR || gui.m_93024_(minecraft.f_91077_))) {
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            int j = (screenHeight - 1) / 2 - 11;
            int k = (screenWidth - 1) / 2 - 3;
            Entity entity = minecraft.f_91076_;
            if (entity instanceof QuestRam) {
                QuestRam ram = (QuestRam)entity;
                ItemStack stack = player.m_150109_().m_8020_(player.m_150109_().f_35977_);
                if (!stack.m_41619_() && stack.m_204117_(ItemTags.f_13167_)) {
                    if (ram.guessColor(stack) != null && !ram.isColorPresent(Objects.requireNonNull(ram.guessColor(stack)))) {
                        GuiComponent.m_93228_((PoseStack)poseStack, (int)k, (int)j, (int)0, (int)0, (int)7, (int)7);
                    } else {
                        GuiComponent.m_93228_((PoseStack)poseStack, (int)k, (int)j, (int)7, (int)0, (int)7, (int)7);
                    }
                }
            }
        }
    }
}

