/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.curios;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.capability.CurioItemCapability;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.TrophyBlock;
import twilightforest.compat.curios.renderer.CharmOfKeepingRenderer;
import twilightforest.compat.curios.renderer.CharmOfLife1NecklaceRenderer;
import twilightforest.compat.curios.renderer.CharmOfLife2NecklaceRenderer;
import twilightforest.compat.curios.renderer.CurioHeadRenderer;
import twilightforest.events.CharmEvents;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.item.SkullCandleItem;
import twilightforest.item.TrophyItem;
import twilightforest.network.CreateMovingCicadaSoundPacket;
import twilightforest.network.TFPacketHandler;

public class CuriosCompat {
    public static void handleCuriosIMCs() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HEAD.getMessageBuilder().build());
    }

    public static ICapabilityProvider setupCuriosCapability(final ItemStack stack) {
        return CurioItemCapability.createProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            @Nonnull
            public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
                return new ICurio.SoundInfo(SoundEvents.f_11675_, 1.0f, 1.0f);
            }

            public void onEquip(SlotContext context, ItemStack prevStack) {
                if (!context.entity().m_6844_(EquipmentSlot.HEAD).m_150930_(((Block)TFBlocks.CICADA.get()).m_5456_()) && stack.m_150930_(((Block)TFBlocks.CICADA.get()).m_5456_()) && !context.entity().m_9236_().m_5776_()) {
                    TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((SlotContext)context).entity()), (Object)new CreateMovingCicadaSoundPacket(context.entity().m_19879_()));
                }
            }

            public boolean canEquipFromUse(SlotContext slotContext) {
                return true;
            }
        });
    }

    public static void keepCurios(DropRulesEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CompoundTag playerData = CharmEvents.getPlayerData(player);
            if (!player.m_9236_().m_5776_() && CharmEvents.charmUsed != null && playerData.m_128441_("TFCharmInventory") && !playerData.m_128437_("TFCharmInventory", 10).isEmpty()) {
                CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(modifiable -> {
                    int i = 0;
                    while (i < modifiable.getSlots()) {
                        int finalI = i++;
                        event.addOverride(stack -> stack == modifiable.getStackInSlot(finalI), ICurio.DropRule.ALWAYS_KEEP);
                    }
                });
            }
        }
    }

    public static void registerCurioRenderers() {
        CuriosRendererRegistry.register((Item)((Item)TFItems.CHARM_OF_LIFE_1.get()), CharmOfLife1NecklaceRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)TFItems.CHARM_OF_LIFE_2.get()), CharmOfLife2NecklaceRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)TFItems.CHARM_OF_KEEPING_1.get()), CharmOfKeepingRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)TFItems.CHARM_OF_KEEPING_2.get()), CharmOfKeepingRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)TFItems.CHARM_OF_KEEPING_3.get()), CharmOfKeepingRenderer::new);
        CuriosRendererRegistry.register((Item)((TrophyBlock)((Object)TFBlocks.NAGA_TROPHY.get())).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((TrophyBlock)((Object)TFBlocks.LICH_TROPHY.get())).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((TrophyBlock)((Object)TFBlocks.MINOSHROOM_TROPHY.get())).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((TrophyBlock)((Object)TFBlocks.HYDRA_TROPHY.get())).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((TrophyBlock)((Object)TFBlocks.KNIGHT_PHANTOM_TROPHY.get())).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((TrophyBlock)((Object)TFBlocks.UR_GHAST_TROPHY.get())).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((TrophyBlock)((Object)TFBlocks.ALPHA_YETI_TROPHY.get())).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((TrophyBlock)((Object)TFBlocks.SNOW_QUEEN_TROPHY.get())).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((TrophyBlock)((Object)TFBlocks.QUEST_RAM_TROPHY.get())).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((Block)TFBlocks.CICADA.get()).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((Block)TFBlocks.FIREFLY.get()).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((Block)TFBlocks.MOONWORM.get()).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((AbstractSkullCandleBlock)((Object)TFBlocks.CREEPER_SKULL_CANDLE.get())).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((AbstractSkullCandleBlock)((Object)TFBlocks.PLAYER_SKULL_CANDLE.get())).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((AbstractSkullCandleBlock)((Object)TFBlocks.SKELETON_SKULL_CANDLE.get())).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((AbstractSkullCandleBlock)((Object)TFBlocks.WITHER_SKELE_SKULL_CANDLE.get())).m_5456_(), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((AbstractSkullCandleBlock)((Object)TFBlocks.ZOMBIE_SKULL_CANDLE.get())).m_5456_(), CurioHeadRenderer::new);
    }

    public static boolean isCicadaEquipped(LivingEntity entity) {
        Optional slot = CuriosApi.getCuriosHelper().findFirstCurio(entity, stack -> stack.m_150930_(((Block)TFBlocks.CICADA.get()).m_5456_()));
        return slot.isPresent();
    }

    public static boolean isTrophyCurioEquipped(LivingEntity entity) {
        Optional slot = CuriosApi.getCuriosHelper().findFirstCurio(entity, stack -> stack.m_41720_() instanceof TrophyItem);
        return slot.isPresent() && ((SlotResult)slot.get()).slotContext() != null && ((SlotResult)slot.get()).slotContext().visible();
    }

    public static boolean isSkullCurioEquipped(LivingEntity entity) {
        Optional slot = CuriosApi.getCuriosHelper().findFirstCurio(entity, stack -> stack.m_41720_() instanceof SkullCandleItem);
        return slot.isPresent() && ((SlotResult)slot.get()).slotContext() != null && ((SlotResult)slot.get()).slotContext().visible();
    }
}

