/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import oshi.util.tuples.Pair;
import twilightforest.init.TFRecipes;

public abstract class CrumbleHornProvider
implements DataProvider {
    private final PackOutput output;
    private final String modId;
    private final ExistingFileHelper helper;
    protected final Map<String, Pair<BlockState, BlockState>> builders = Maps.newLinkedHashMap();

    public CrumbleHornProvider(PackOutput output, String modId, ExistingFileHelper helper) {
        this.output = output;
        this.modId = modId;
        this.helper = helper;
    }

    public abstract void registerTransforms();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.builders.clear();
        this.registerTransforms();
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        this.builders.forEach((name, transform) -> {
            List list = this.builders.keySet().stream().filter(s -> ForgeRegistries.BLOCKS.containsValue((Object)((BlockState)transform.getA()).m_60734_())).filter(s -> ForgeRegistries.BLOCKS.containsValue((Object)((BlockState)transform.getB()).m_60734_())).filter(s -> !this.builders.containsKey(s)).filter(this::missing).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Duplicate Crumble Horn Transformations: %s", list.stream().map(Objects::toString).collect(Collectors.joining(", "))));
            }
            JsonObject obj = this.serializeToJson((BlockState)transform.getA(), (BlockState)transform.getB());
            Path path = this.createPath(new ResourceLocation(this.modId, name));
            futuresBuilder.add((Object)DataProvider.m_253162_((CachedOutput)cache, (JsonElement)obj, (Path)path));
        });
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    private boolean missing(String name) {
        return !this.helper.exists(new ResourceLocation(this.modId, name), (ExistingFileHelper.IResourceType)new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", "crumble_horn"));
    }

    private Path createPath(ResourceLocation name) {
        return this.output.m_245114_().resolve("data/" + name.m_135827_() + "/recipes/crumble_horn/" + name.m_135815_() + ".json");
    }

    private JsonObject serializeToJson(BlockState transformFrom, BlockState transformTo) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", ForgeRegistries.RECIPE_SERIALIZERS.getKey((Object)((RecipeSerializer)TFRecipes.CRUMBLE_SERIALIZER.get())).toString());
        jsonobject.addProperty("from", ForgeRegistries.BLOCKS.getKey((Object)transformFrom.m_60734_()).toString());
        jsonobject.addProperty("to", ForgeRegistries.BLOCKS.getKey((Object)transformTo.m_60734_()).toString());
        return jsonobject;
    }

    public String m_6055_() {
        return this.modId + " Crumble Horn Transformations";
    }

    public void addTransform(Block from, Block to) {
        this.builders.put(ForgeRegistries.BLOCKS.getKey((Object)from).m_135815_() + "_to_" + ForgeRegistries.BLOCKS.getKey((Object)to).m_135815_(), (Pair<BlockState, BlockState>)new Pair((Object)from.m_49966_(), (Object)to.m_49966_()));
    }

    public void addDissolve(Block dissolveBlock) {
        this.builders.put("dissolve_" + ForgeRegistries.BLOCKS.getKey((Object)dissolveBlock).m_135815_(), (Pair<BlockState, BlockState>)new Pair((Object)dissolveBlock.m_49966_(), (Object)Blocks.f_50016_.m_49966_()));
    }
}

