/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFChestBlock;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.TFPart;
import twilightforest.entity.ai.control.NagaMoveControl;
import twilightforest.entity.ai.goal.NagaMovementPattern;
import twilightforest.entity.ai.goal.NagaSmashGoal;
import twilightforest.entity.ai.goal.SimplifiedAttackGoal;
import twilightforest.entity.boss.IBossLootBuffer;
import twilightforest.entity.boss.NagaSegment;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStructures;
import twilightforest.network.ParticlePacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.ThrowPlayerPacket;
import twilightforest.util.EntityUtil;
import twilightforest.util.LandmarkUtil;

public class Naga
extends Monster
implements EnforcedHomePoint,
IBossLootBuffer {
    private static final int TICKS_BEFORE_HEALING = 600;
    private static final int MAX_SEGMENTS = 12;
    private static final int LEASH_X = 46;
    private static final int LEASH_Y = 7;
    private static final int LEASH_Z = 46;
    private static final double DEFAULT_SPEED = 0.3;
    private int currentSegmentCount = 0;
    private final float healthPerSegment;
    private final NagaSegment[] bodySegments = new NagaSegment[12];
    private NagaMovementPattern movementAI;
    private int ticksSinceDamaged = 0;
    private final List<ServerPlayer> hurtBy = new ArrayList<ServerPlayer>();
    private final NonNullList<ItemStack> dyingInventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.NOTCHED_10);
    private final AttributeModifier slowSpeed = new AttributeModifier("Naga Slow Speed", 0.25, AttributeModifier.Operation.ADDITION);
    private final AttributeModifier fastSpeed = new AttributeModifier("Naga Fast Speed", 0.5, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> DATA_DAZE = SynchedEntityData.m_135353_(Naga.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_CHARGE = SynchedEntityData.m_135353_(Naga.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Naga(EntityType<? extends Naga> type, Level level) {
        super(type, level);
        this.f_21364_ = 217;
        this.f_19811_ = true;
        for (int i = 0; i < this.bodySegments.length; ++i) {
            this.bodySegments[i] = new NagaSegment(this);
        }
        this.goNormal();
        this.healthPerSegment = this.m_21233_() / 10.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_DAZE, (Object)false);
        this.f_19804_.m_135372_(DATA_CHARGE, (Object)false);
    }

    public boolean isDazed() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DAZE);
    }

    public void setDazed(boolean daze) {
        this.f_19804_.m_135381_(DATA_DAZE, (Object)daze);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGE);
    }

    public void setCharging(boolean charge) {
        this.f_19804_.m_135381_(DATA_CHARGE, (Object)charge);
    }

    public NagaMovementPattern getMovementAI() {
        return this.movementAI;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SimplifiedAttackGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new NagaSmashGoal(this));
        this.movementAI = new NagaMovementPattern(this);
        this.f_21345_.m_25352_(4, (Goal)this.movementAI);
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0){

            public void m_8056_() {
                Naga.this.m_6710_(null);
                super.m_8056_();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 1){

            public void m_8056_() {
                Naga.this.goNormal();
                super.m_8056_();
            }

            protected Vec3 m_7037_() {
                return DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)30, (int)7);
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, false){

            public boolean m_8036_() {
                return Naga.this.m_21444_(Naga.this.m_20183_()) && super.m_8036_();
            }
        });
        this.f_21342_ = new NagaMoveControl(this);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().m_5776_() || !ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            return;
        }
        AABB bb = this.m_20191_();
        int minx = Mth.m_14107_((double)(bb.f_82288_ - 0.75));
        int miny = Mth.m_14107_((double)(bb.f_82289_ + (double)(this.shouldDestroyAllBlocks() ? 1.01f : 0.5f)));
        int minz = Mth.m_14107_((double)(bb.f_82290_ - 0.75));
        int maxx = Mth.m_14107_((double)(bb.f_82291_ + 0.75));
        int maxy = Mth.m_14107_((double)(bb.f_82292_ + 1.0));
        int maxz = Mth.m_14107_((double)(bb.f_82293_ + 0.75));
        BlockPos min = new BlockPos(minx, miny, minz);
        BlockPos max = new BlockPos(maxx, maxy, maxz);
        if (this.m_9236_().m_46832_(min, max)) {
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
                BlockState state = this.m_9236_().m_8055_(pos);
                if (!state.m_204336_(BlockTags.f_13035_) && (!this.shouldDestroyAllBlocks() || !EntityUtil.canDestroyBlock(this.m_9236_(), pos, (Entity)this))) continue;
                this.m_9236_().m_46961_(pos, !state.m_204336_(BlockTags.f_13035_));
            }
        }
    }

    public boolean shouldDestroyAllBlocks() {
        return this.isCharging() || !this.m_21533_();
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 80.0).m_22268_(Attributes.f_22278_, 0.25);
    }

    private void setSegmentsPerHealth() {
        int newSegments;
        int oldSegments = this.currentSegmentCount;
        this.currentSegmentCount = newSegments = Mth.m_14045_((int)((int)(this.m_21223_() / this.healthPerSegment + (float)(this.m_21223_() > 0.0f ? 2 : 0))), (int)0, (int)12);
        if (newSegments < oldSegments) {
            for (int i = newSegments; i < oldSegments; ++i) {
                this.bodySegments[i].selfDestruct((oldSegments - i) * 12);
            }
        } else if (newSegments > oldSegments) {
            this.activateBodySegments();
        }
        if (!this.m_9236_().m_5776_()) {
            double newSpeed = 0.3 - (double)((float)newSegments * -0.016666668f);
            if (newSpeed < 0.0) {
                newSpeed = 0.0;
            }
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(newSpeed);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (this.m_9236_().m_46791_() != Difficulty.EASY && this.m_21051_(Attributes.f_22276_) != null) {
            boolean hard = this.f_19853_.m_46791_() == Difficulty.HARD;
            AttributeModifier modifier = new AttributeModifier("Difficulty Health Boost", hard ? 130.0 : 80.0, AttributeModifier.Operation.ADDITION);
            if (!Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22109_(modifier)) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22125_(modifier);
                this.m_21153_(this.m_21233_());
            }
        }
        return data;
    }

    public boolean m_20161_() {
        return false;
    }

    public boolean m_20077_() {
        return false;
    }

    public void m_8119_() {
        if (this.isDazed() && this.f_20919_ < 10) {
            for (int i = 0; i < 5; ++i) {
                Vec3 pos = new Vec3(this.m_20185_(), this.m_20186_() + 2.15, this.m_20189_()).m_82549_(new Vec3(1.5, 0.0, 0.0).m_82524_((float)Math.toRadians(this.m_217043_().m_188503_(360))));
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 0.0, 0.0, 0.0);
            }
        }
        ++this.ticksSinceDamaged;
        if (!this.m_9236_().m_5776_() && this.ticksSinceDamaged > 600 && this.ticksSinceDamaged % 20 == 0) {
            this.m_5634_(1.0f);
        }
        this.setSegmentsPerHealth();
        super.m_8119_();
        this.moveSegments();
    }

    protected void m_8024_() {
        Vec3 vec3d;
        super.m_8024_();
        if (this.m_5448_() != null && (this.m_20280_((Entity)this.m_5448_()) > 6400.0 || !this.areSelfAndTargetInHome((Entity)this.m_5448_()))) {
            this.m_6710_(null);
        }
        double d = this.m_20205_() * 4.0f;
        Vec3 vec3 = vec3d = this.m_21691_() ? Objects.requireNonNull(this.m_21573_().m_26570_()).m_77380_((Entity)this) : null;
        while (vec3d != null && vec3d.m_82531_(this.m_20185_(), vec3d.m_7098_(), this.m_20189_()) < d * d) {
            this.m_21573_().m_26570_().m_77374_();
            if (this.m_21573_().m_26570_().m_77392_()) {
                vec3d = null;
                continue;
            }
            vec3d = this.m_21573_().m_26570_().m_77380_((Entity)this);
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.NAGA_HISS.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.NAGA_HURT.get();
    }

    public void m_6677_(DamageSource pSource) {
        super.m_6677_(pSource);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.NAGA_HURT.get();
    }

    public void goSlow() {
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22130_(this.slowSpeed);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22130_(this.fastSpeed);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22118_(this.slowSpeed);
    }

    public void goNormal() {
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22130_(this.slowSpeed);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22130_(this.fastSpeed);
    }

    public void goFast() {
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22130_(this.slowSpeed);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22130_(this.fastSpeed);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22118_(this.fastSpeed);
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6673_(DamageSource src) {
        return src.m_7639_() != null && !this.isEntityWithinHomeArea(src.m_7639_()) || src.m_7640_() != null && !this.isEntityWithinHomeArea(src.m_7640_()) || src.m_269533_(DamageTypeTags.f_268415_) || super.m_6673_(src);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            ServerPlayer player;
            this.ticksSinceDamaged = 0;
            Entity entity = source.m_7639_();
            if (entity instanceof ServerPlayer && !this.hurtBy.contains(player = (ServerPlayer)entity)) {
                this.hurtBy.add(player);
            }
            return true;
        }
        return false;
    }

    public boolean m_7327_(Entity toAttack) {
        LivingEntity living;
        if (this.movementAI.getState() == NagaMovementPattern.MovementState.CHARGE && toAttack instanceof LivingEntity && (living = (LivingEntity)toAttack).m_21254_()) {
            Vec3 motion = this.m_20184_();
            toAttack.m_5997_(motion.m_7096_() * 1.5, 0.5, motion.m_7094_() * 1.5);
            this.m_5997_(motion.m_7096_() * -1.25, 0.5, motion.m_7094_() * -1.25);
            if (toAttack instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)toAttack;
                player.m_21211_().m_41622_(5, (LivingEntity)player, user -> user.m_21190_(player.m_7655_()));
                TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ThrowPlayerPacket(motion.m_7096_() * 3.0, motion.m_7098_() + 0.75, motion.m_7094_() * 3.0));
            }
            this.m_6469_(this.m_269291_().m_269264_(), 4.0f);
            this.m_9236_().m_5594_(null, toAttack.m_20183_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 0.8f + this.m_9236_().m_213780_().m_188501_() * 0.4f);
            this.movementAI.doDaze();
            return false;
        }
        if (!this.isDazed()) {
            boolean result = super.m_7327_(toAttack);
            if (result) {
                toAttack.m_5997_((double)(-Mth.m_14031_((float)(this.m_146908_() * (float)Math.PI / 180.0f)) * 2.0f), (double)0.4f, (double)(Mth.m_14089_((float)(this.m_146908_() * (float)Math.PI / 180.0f)) * 2.0f));
            }
            return result;
        }
        return false;
    }

    public float m_21692_(BlockPos pos) {
        if (!this.m_21444_(pos)) {
            return Float.MIN_VALUE;
        }
        return 0.0f;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            if (this.m_21534_() != BlockPos.f_121853_) {
                this.m_9236_().m_46597_(this.m_21534_(), ((Block)TFBlocks.NAGA_BOSS_SPAWNER.get()).m_49966_());
            }
            this.m_146870_();
        } else {
            super.m_6043_();
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        Level level;
        if (reason.equals((Object)Entity.RemovalReason.KILLED) && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            IBossLootBuffer.depositDropsIntoChest(this, this.f_19796_.m_188499_() ? ((TFChestBlock)((Object)TFBlocks.TWILIGHT_OAK_CHEST.get())).m_49966_() : ((TFChestBlock)((Object)TFBlocks.CANOPY_CHEST.get())).m_49966_(), EntityUtil.bossChestLocation((Mob)this), serverLevel);
        }
        super.m_142687_(reason);
        if (this.m_9236_() instanceof ServerLevel) {
            for (NagaSegment seg : this.bodySegments) {
                seg.m_6074_();
            }
        }
    }

    public boolean m_21444_(BlockPos pos) {
        if (this.m_21535_() == -1.0f) {
            return true;
        }
        int distX = Math.abs(this.m_21534_().m_123341_() - pos.m_123341_());
        int distY = Math.abs(this.m_21534_().m_123342_() - pos.m_123342_());
        int distZ = Math.abs(this.m_21534_().m_123343_() - pos.m_123343_());
        return distX <= 46 && distY <= 7 && distZ <= 46;
    }

    public boolean isEntityWithinHomeArea(Entity entity) {
        return this.m_21444_(entity.m_20183_());
    }

    public boolean areSelfAndTargetInHome(Entity entity) {
        return this.m_21444_(this.m_20183_()) && this.isEntityWithinHomeArea(entity);
    }

    private void activateBodySegments() {
        for (int i = 0; i < this.currentSegmentCount; ++i) {
            NagaSegment segment = this.bodySegments[i];
            segment.activate();
            segment.m_7678_(this.m_20185_() + 0.1 * (double)i, this.m_20186_() + 0.5, this.m_20189_() + 0.1 * (double)i, this.m_217043_().m_188501_() * 360.0f, 0.0f);
            for (int j = 0; j < 20; ++j) {
                double d0 = this.m_217043_().m_188583_() * 0.02;
                double d1 = this.m_217043_().m_188583_() * 0.02;
                double d2 = this.m_217043_().m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, segment.m_20185_() + (double)(this.m_217043_().m_188501_() * segment.m_20205_() * 2.0f) - (double)segment.m_20205_() - d0 * 10.0, segment.m_20186_() + (double)(this.m_217043_().m_188501_() * segment.m_20206_()) - d1 * 10.0, segment.m_20189_() + (double)(this.m_217043_().m_188501_() * segment.m_20205_() * 2.0f) - (double)segment.m_20205_() - d2 * 10.0, d0, d1, d2);
            }
        }
    }

    private void moveSegments() {
        for (int i = 0; i < this.bodySegments.length; ++i) {
            this.bodySegments[i].m_8119_();
            Naga leader = i == 0 ? this : this.bodySegments[i - 1];
            double followX = leader.m_20185_();
            double followY = leader.m_20186_();
            double followZ = leader.m_20189_();
            float angle = (leader.m_146908_() + 180.0f) * (float)Math.PI / 180.0f;
            double straightenForce = 0.05 + 1.0 / (double)(i + 1) * 0.5;
            if (this.m_21224_()) {
                straightenForce = 0.0;
            }
            double idealX = (double)(-Mth.m_14031_((float)angle)) * straightenForce;
            double idealZ = (double)Mth.m_14089_((float)angle) * straightenForce;
            double groundY = this.bodySegments[i].m_5830_() ? followY + 2.0 : followY;
            double idealY = (groundY - followY) * straightenForce;
            Vec3 diff = new Vec3(this.bodySegments[i].m_20185_() - followX, this.bodySegments[i].m_20186_() - followY, this.bodySegments[i].m_20189_() - followZ);
            diff = diff.m_82541_();
            diff = diff.m_82520_(idealX, idealY, idealZ).m_82541_();
            double f = 2.0;
            double destX = followX + f * diff.m_7096_();
            double destY = followY + f * diff.m_7098_();
            double destZ = followZ + f * diff.m_7094_();
            this.bodySegments[i].m_6034_(destX, destY, destZ);
            double distance = Mth.m_14116_((float)((float)(diff.m_7096_() * diff.m_7096_() + diff.m_7094_() * diff.m_7094_())));
            if (i == 0) {
                diff = diff.m_82520_(0.0, -0.15, 0.0);
            }
            this.bodySegments[i].m_19915_((float)(Math.atan2(diff.m_7094_(), diff.m_7096_()) * 180.0 / Math.PI) + 90.0f, -((float)(Math.atan2(diff.m_7098_(), distance) * 180.0 / Math.PI)));
        }
    }

    public void m_7380_(CompoundTag compound) {
        this.saveHomePointToNbt(compound);
        this.addDeathItemsSaveData(compound);
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.readDeathItemsSaveData(compound);
        this.loadHomePointFromNbt(compound, 20);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LandmarkUtil.markStructureConquered((LevelAccessor)this.m_9236_(), this, TFStructures.NAGA_COURTYARD, true);
            for (ServerPlayer player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (Entity)this);
            }
            IBossLootBuffer.saveDropsIntoBoss(this, this.m_7771_(true, cause).m_78975_(LootContextParamSets.f_81415_), serverLevel);
        }
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
            int renderEnd = 24;
            int maxDeath = renderEnd + 120;
            if (this.f_20919_ >= renderEnd) {
                if (this.f_20919_ == renderEnd) {
                    SoundEvent soundevent = this.m_5592_();
                    if (soundevent != null) {
                        this.m_5496_(soundevent, this.m_6121_() * 1.2f, this.m_6100_() * 0.75f);
                    }
                    this.f_19853_.m_7605_((Entity)this, (byte)60);
                } else if (this.f_20919_ >= maxDeath) {
                    this.m_142687_(Entity.RemovalReason.KILLED);
                } else {
                    Vec3 start = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.5, 0.0);
                    Vec3 end = Vec3.m_82512_((Vec3i)EntityUtil.bossChestLocation((Mob)this));
                    Vec3 diff = end.m_82546_(start);
                    ParticlePacket particlePacket = new ParticlePacket();
                    if (this.f_20919_ >= maxDeath - 3) {
                        for (int i = 0; i < 40; ++i) {
                            double x = (this.f_19796_.m_188500_() - 0.5) * 0.075 * (double)i;
                            double y = (this.f_19796_.m_188500_() - 0.5) * 0.075 * (double)i;
                            double z = (this.f_19796_.m_188500_() - 0.5) * 0.075 * (double)i;
                            particlePacket.queueParticle((ParticleOptions)ParticleTypes.f_123759_, false, end.m_82520_(x, y, z), Vec3.f_82478_);
                        }
                    }
                    double angle = Math.atan2(end.f_82481_ - start.f_82481_, end.f_82479_ - start.f_82479_) * 57.2957763671875 + 180.0;
                    double xMul = angle % 180.0;
                    xMul = Math.min(xMul, 180.0 - xMul);
                    xMul = Math.pow(xMul / 90.0, 1.5) * 2.0;
                    double zMul = (angle + 90.0) % 180.0;
                    zMul = Math.min(zMul, 180.0 - zMul);
                    zMul = Math.pow(zMul / 90.0, 1.5) * 2.0;
                    for (int p = 0; p < 4; ++p) {
                        int trailTime = this.f_20919_ - renderEnd - p + 1;
                        if (trailTime < 0) continue;
                        for (double d = 0.0; d < 1.0; d += 0.25) {
                            double preciseTime = (double)trailTime - d;
                            if (preciseTime < 0.0) continue;
                            double factor = preciseTime / (double)(maxDeath - renderEnd);
                            Vec3 particlePos = start.m_82549_(diff.m_82490_(factor)).m_82520_(Math.sin(preciseTime * Math.PI * 0.075) * xMul, Math.sin(preciseTime * Math.PI * 0.025) * 0.1, Math.cos(preciseTime * Math.PI * 0.0625) * zMul);
                            BlockHitResult blockhitresult = this.f_19853_.m_45547_(new ClipContext(particlePos.m_82520_(0.0, 2.0, 0.0), particlePos.m_82492_(0.0, 3.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.WATER, null));
                            particlePacket.queueParticle((ParticleOptions)ParticleTypes.f_123749_, false, blockhitresult.m_82450_().m_82520_(0.0, 0.15, 0.0), Vec3.f_82478_);
                        }
                    }
                    TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)particlePacket);
                }
            }
        }
    }

    public void m_7822_(byte id) {
        if (id == 60) {
            Vec3 pos = this.m_20182_();
            float width = this.m_20205_();
            float height = this.m_20206_();
            for (int k = 0; k < 20; ++k) {
                this.m_9236_().m_7106_((ParticleOptions)(this.f_19796_.m_188499_() ? ParticleTypes.f_123813_ : ParticleTypes.f_123759_), pos.f_82479_ + (double)(this.f_19796_.m_188501_() * width * 2.0f) - (double)width, pos.f_82480_ + (double)(this.f_19796_.m_188501_() * height), pos.f_82481_ + (double)(this.f_19796_.m_188501_() * width * 2.0f) - (double)width, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02);
            }
        }
        super.m_7822_(id);
    }

    protected boolean m_6125_() {
        return false;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        TFPart.assignPartIDs((Entity)this);
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.bodySegments;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public float getStepHeight() {
        return 2.0f;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    public boolean m_6072_() {
        return false;
    }

    @Override
    public BlockPos getRestrictionCenter() {
        return this.m_21534_();
    }

    @Override
    public void setRestriction(BlockPos pos, int dist) {
        this.m_21446_(pos, dist);
    }

    @Override
    public NonNullList<ItemStack> getItemStacks() {
        return this.dyingInventory;
    }
}

