/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.world.components.feature.trees.treeplacers.BranchingTrunkPlacer;
import twilightforest.world.components.feature.trees.treeplacers.DangleFromTreeDecorator;
import twilightforest.world.components.feature.trees.treeplacers.LeafSpheroidFoliagePlacer;
import twilightforest.world.components.feature.trees.treeplacers.TreeCorePlacer;
import twilightforest.world.components.feature.trees.treeplacers.TreeRootsDecorator;
import twilightforest.world.components.feature.trees.treeplacers.TrunkRiser;
import twilightforest.world.components.feature.trees.treeplacers.TrunkSideDecorator;
import twilightforest.world.components.placements.AvoidLandmarkModifier;
import twilightforest.world.components.placements.ChunkBlanketingModifier;
import twilightforest.world.components.placements.ChunkCenterModifier;

public final class TFFeatureModifiers {
    public static final DeferredRegister<FoliagePlacerType<?>> FOLIAGE_PLACERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FOLIAGE_PLACER_TYPES, (String)"twilightforest");
    public static final DeferredRegister<TreeDecoratorType<?>> TREE_DECORATORS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TREE_DECORATOR_TYPES, (String)"twilightforest");
    public static final DeferredRegister<PlacementModifierType<?>> PLACEMENT_MODIFIERS = DeferredRegister.create((ResourceKey)Registries.f_256843_, (String)"twilightforest");
    public static final DeferredRegister<TrunkPlacerType<?>> TRUNK_PLACERS = DeferredRegister.create((ResourceKey)Registries.f_256963_, (String)"twilightforest");
    public static final RegistryObject<TrunkPlacerType<BranchingTrunkPlacer>> TRUNK_BRANCHING = TRUNK_PLACERS.register("branching_trunk_placer", () -> new TrunkPlacerType(BranchingTrunkPlacer.CODEC));
    public static final RegistryObject<TrunkPlacerType<TrunkRiser>> TRUNK_RISER = TRUNK_PLACERS.register("trunk_mover_upper", () -> new TrunkPlacerType(TrunkRiser.CODEC));
    public static final RegistryObject<FoliagePlacerType<LeafSpheroidFoliagePlacer>> FOLIAGE_SPHEROID = FOLIAGE_PLACERS.register("spheroid_foliage_placer", () -> new FoliagePlacerType(LeafSpheroidFoliagePlacer.CODEC));
    public static final RegistryObject<TreeDecoratorType<TreeCorePlacer>> CORE_PLACER = TREE_DECORATORS.register("core_placer", () -> new TreeDecoratorType(TreeCorePlacer.CODEC));
    public static final RegistryObject<TreeDecoratorType<TrunkSideDecorator>> TRUNKSIDE_DECORATOR = TREE_DECORATORS.register("trunkside_decorator", () -> new TreeDecoratorType(TrunkSideDecorator.CODEC));
    public static final RegistryObject<TreeDecoratorType<TreeRootsDecorator>> TREE_ROOTS = TREE_DECORATORS.register("tree_roots", () -> new TreeDecoratorType(TreeRootsDecorator.CODEC));
    public static final RegistryObject<TreeDecoratorType<DangleFromTreeDecorator>> DANGLING_DECORATOR = TREE_DECORATORS.register("dangle_from_tree_decorator", () -> new TreeDecoratorType(DangleFromTreeDecorator.CODEC));
    public static final RegistryObject<PlacementModifierType<AvoidLandmarkModifier>> NO_STRUCTURE = TFFeatureModifiers.registerPlacer("no_structure", () -> () -> AvoidLandmarkModifier.CODEC);
    public static final RegistryObject<PlacementModifierType<ChunkCenterModifier>> CHUNK_CENTERER = TFFeatureModifiers.registerPlacer("chunk_centerer", () -> () -> ChunkCenterModifier.CODEC);
    public static final RegistryObject<PlacementModifierType<ChunkBlanketingModifier>> CHUNK_BLANKETING = TFFeatureModifiers.registerPlacer("chunk_blanketing", () -> () -> ChunkBlanketingModifier.CODEC);

    private static <P extends PlacementModifier> RegistryObject<PlacementModifierType<P>> registerPlacer(String name, Supplier<PlacementModifierType<P>> factory) {
        return PLACEMENT_MODIFIERS.register(name, factory);
    }
}

