/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;
import org.jetbrains.annotations.Nullable;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.entity.ChainBlock;
import twilightforest.init.TFEnchantments;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;

public class ChainBlockItem
extends Item {
    private static final String THROWN_UUID_KEY = "chainEntity";

    public ChainBlockItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return this.canApplyEnchantment(EnchantmentHelper.m_44831_((ItemStack)stack).keySet().toArray(new Enchantment[0])) || super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.canApplyEnchantment(enchantment) || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private boolean canApplyEnchantment(Enchantment ... enchantments) {
        for (Enchantment enchantment : enchantments) {
            if (enchantment.f_44672_ != EnchantmentCategory.DIGGER && !enchantment.m_6081_(Items.f_42386_.m_7968_())) continue;
            return true;
        }
        return false;
    }

    public void m_6883_(ItemStack stack, Level level, Entity holder, int slot, boolean isSelected) {
        if (!level.m_5776_() && ChainBlockItem.getThrownUuid(stack) != null && this.getThrownEntity(level, stack) == null) {
            stack.m_41783_().m_128473_(THROWN_UUID_KEY);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (ChainBlockItem.getThrownUuid(stack) != null) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        player.m_5496_((SoundEvent)TFSounds.BLOCKCHAIN_FIRED.get(), 0.5f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 1.2f));
        if (!level.m_5776_()) {
            ChainBlock launchedBlock = new ChainBlock((EntityType<? extends ChainBlock>)((EntityType)TFEntities.CHAIN_BLOCK.get()), level, (LivingEntity)player, hand, stack);
            level.m_7967_((Entity)launchedBlock);
            this.setThrownEntity(stack, launchedBlock);
        }
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Nullable
    public static UUID getThrownUuid(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128403_(THROWN_UUID_KEY)) {
            return stack.m_41783_().m_128342_(THROWN_UUID_KEY);
        }
        return null;
    }

    @Nullable
    private ChainBlock getThrownEntity(Level level, ItemStack stack) {
        if (level instanceof ServerLevel) {
            Entity e;
            ServerLevel server = (ServerLevel)level;
            UUID id = ChainBlockItem.getThrownUuid(stack);
            if (id != null && (e = server.m_8791_(id)) instanceof ChainBlock) {
                return (ChainBlock)e;
            }
        }
        return null;
    }

    private void setThrownEntity(ItemStack stack, ChainBlock cube) {
        stack.m_41784_().m_128362_(THROWN_UUID_KEY, cube.m_20148_());
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairItem) {
        return repairItem.m_204117_(ItemTagGenerator.KNIGHTMETAL_INGOTS);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_(THROWN_UUID_KEY)) {
            return false;
        }
        if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)TFEnchantments.DESTRUCTION.get()), (ItemStack)stack) > 0 && (state.m_204336_(BlockTags.f_144282_) || state.m_204336_(BlockTags.f_144281_) || state.m_204336_(BlockTags.f_144283_) || state.m_204336_(BlockTags.f_144280_))) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.getHarvestLevel(stack), (BlockState)state);
        }
        return false;
    }

    public Tier getHarvestLevel(ItemStack stack) {
        int enchantLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)TFEnchantments.DESTRUCTION.get()), (ItemStack)stack);
        if (enchantLevel == 2) {
            return Tiers.STONE;
        }
        if (enchantLevel >= 3) {
            return Tiers.IRON;
        }
        return Tiers.WOOD;
    }
}

