/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class EntityUtil {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Method LivingEntity_getDeathSound = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_5592_", (Class[])new Class[0]);
    private static final MethodHandle handle_LivingEntity_getDeathSound;
    private static final Method HangingEntity_setDirection;
    private static final MethodHandle handle_HangingEntity_setDirection;

    public static BlockPos bossChestLocation(Mob boss) {
        return boss.m_21534_() == BlockPos.f_121853_ ? boss.m_20183_() : boss.m_21534_().m_7495_();
    }

    public static boolean canDestroyBlock(Level world, BlockPos pos, Entity entity) {
        return EntityUtil.canDestroyBlock(world, pos, world.m_8055_(pos), entity);
    }

    public static boolean canDestroyBlock(Level world, BlockPos pos, BlockState state, Entity entity) {
        float hardness = state.m_60800_((BlockGetter)world, pos);
        return hardness >= 0.0f && hardness < 50.0f && !state.m_60795_() && state.m_60734_().canEntityDestroy(state, (BlockGetter)world, pos, entity) && (!(entity instanceof LivingEntity) || ForgeEventFactory.onEntityDestroyBlock((LivingEntity)((LivingEntity)entity), (BlockPos)pos, (BlockState)state));
    }

    public static BlockHitResult rayTrace(Entity entity, double range) {
        Vec3 position = entity.m_20299_(1.0f);
        Vec3 look = entity.m_20252_(1.0f);
        Vec3 dest = position.m_82520_(look.f_82479_ * range, look.f_82480_ * range, look.f_82481_ * range);
        return entity.f_19853_.m_45547_(new ClipContext(position, dest, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity));
    }

    public static BlockHitResult rayTrace(Player player) {
        return EntityUtil.rayTrace(player, null);
    }

    public static BlockHitResult rayTrace(Player player, @Nullable DoubleUnaryOperator modifier) {
        double range = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
        return EntityUtil.rayTrace((Entity)player, modifier == null ? range : modifier.applyAsDouble(range));
    }

    @Nullable
    public static SoundEvent getDeathSound(LivingEntity living) {
        SoundEvent sound = null;
        if (handle_LivingEntity_getDeathSound != null) {
            try {
                sound = handle_LivingEntity_getDeathSound.invokeExact(living);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sound;
    }

    public static void killLavaAround(Entity entity) {
        AABB bounds = entity.m_20191_().m_82400_(9.0);
        for (double x = bounds.f_82288_; x < bounds.f_82291_; x += 1.0) {
            for (double z = bounds.f_82290_; z < bounds.f_82293_; z += 1.0) {
                for (double y = bounds.f_82289_; y < bounds.f_82292_; y += 1.0) {
                    BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
                    BlockState state = entity.m_9236_().m_8055_(pos);
                    if (!state.m_60713_(Blocks.f_49991_)) continue;
                    entity.m_9236_().m_46597_(pos, Blocks.f_50016_.m_49966_());
                }
            }
        }
    }

    public static boolean properlyApplyCustomDamageSource(Mob entity, Entity victim, DamageSource source) {
        boolean flag;
        int i;
        float f = (float)entity.m_21133_(Attributes.f_22281_);
        float f1 = (float)entity.m_21133_(Attributes.f_22282_);
        if (victim instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)entity.m_21205_(), (MobType)((LivingEntity)victim).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)entity);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)entity)) > 0) {
            victim.m_20254_(i * 4);
        }
        if (flag = victim.m_6469_(source, f)) {
            if (f1 > 0.0f && victim instanceof LivingEntity) {
                ((LivingEntity)victim).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(entity.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(entity.m_146908_() * ((float)Math.PI / 180)))));
                entity.m_20256_(entity.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (victim instanceof Player) {
                Player player = (Player)victim;
                entity.m_21424_(player, entity.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
            }
            entity.m_19970_((LivingEntity)entity, victim);
            entity.m_21335_(victim);
        }
        return flag;
    }

    @Nullable
    private static <T extends Entity> T createEntityIgnoreException(EntityType<T> type, ServerLevelAccessor levelAccessor) {
        try {
            return (T)type.m_20615_((Level)levelAccessor.m_6018_());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void tryHangPainting(WorldGenLevel world, BlockPos pos, Direction direction, @Nullable ResourceKey<PaintingVariant> chosenPainting) {
        if (chosenPainting == null) {
            return;
        }
        Painting painting = (Painting)EntityUtil.createEntityIgnoreException(EntityType.f_20506_, (ServerLevelAccessor)world);
        painting.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        try {
            handle_HangingEntity_setDirection.invoke(painting, direction);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        painting.m_28464_((Holder)ForgeRegistries.PAINTING_VARIANTS.getHolder(chosenPainting).get());
        if (EntityUtil.checkValidPaintingPosition(world, painting)) {
            world.m_7967_((Entity)painting);
        }
    }

    @Nullable
    public static ResourceKey<PaintingVariant> getPaintingOfSize(RandomSource rand, int minSize) {
        return EntityUtil.getPaintingOfSize(rand, minSize, minSize, false);
    }

    @Nullable
    public static ResourceKey<PaintingVariant> getPaintingOfSize(RandomSource rand, int width, int height, boolean exactMeasurements) {
        ArrayList<ResourceKey> valid = new ArrayList<ResourceKey>();
        for (PaintingVariant art : ForgeRegistries.PAINTING_VARIANTS.tags().getTag(PaintingVariantTags.f_215870_)) {
            if (exactMeasurements) {
                if (art.m_218908_() != width || art.m_218909_() != height) continue;
                valid.add(ResourceKey.m_135785_((ResourceKey)Registries.f_256836_, (ResourceLocation)Objects.requireNonNull(ForgeRegistries.PAINTING_VARIANTS.getKey((Object)art))));
                continue;
            }
            if (art.m_218908_() < width && art.m_218909_() < height) continue;
            valid.add(ResourceKey.m_135785_((ResourceKey)Registries.f_256836_, (ResourceLocation)Objects.requireNonNull(ForgeRegistries.PAINTING_VARIANTS.getKey((Object)art))));
        }
        if (valid.size() > 0) {
            return (ResourceKey)valid.get(rand.m_188503_(valid.size()));
        }
        return null;
    }

    public static boolean checkValidPaintingPosition(WorldGenLevel world, @Nullable Painting painting) {
        if (painting == null) {
            return false;
        }
        AABB largerBox = painting.m_20191_();
        if (!world.m_45756_((Entity)painting, largerBox)) {
            return false;
        }
        List<Entity> collidingEntities = EntityUtil.getEntitiesInAABB(world, largerBox);
        for (Entity entityOnList : collidingEntities) {
            if (!(entityOnList instanceof HangingEntity)) continue;
            return false;
        }
        return true;
    }

    public static List<Entity> getEntitiesInAABB(WorldGenLevel world, AABB boundingBox) {
        ArrayList list = Lists.newArrayList();
        int i = Mth.m_14107_((double)((boundingBox.f_82288_ - 2.0) / 16.0));
        int j = Mth.m_14107_((double)((boundingBox.f_82291_ + 2.0) / 16.0));
        int k = Mth.m_14107_((double)((boundingBox.f_82290_ - 2.0) / 16.0));
        int l = Mth.m_14107_((double)((boundingBox.f_82293_ + 2.0) / 16.0));
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                ChunkAccess chunk = world.m_46819_(i1, j1, ChunkStatus.f_62315_);
                if (!(chunk instanceof ProtoChunk)) continue;
                ProtoChunk proto = (ProtoChunk)chunk;
                proto.m_63293_().forEach(nbt -> {
                    Entity entity = EntityType.m_20645_((CompoundTag)nbt, (Level)world.m_6018_(), e -> e);
                    if (entity != null && boundingBox.m_82381_(entity.m_20191_())) {
                        list.add(entity);
                    }
                });
            }
        }
        return list;
    }

    static {
        HangingEntity_setDirection = ObfuscationReflectionHelper.findMethod(HangingEntity.class, (String)"m_6022_", (Class[])new Class[]{Direction.class});
        MethodHandle tmp_handle_LivingEntity_getDeathSound = null;
        MethodHandle tmp_handle_HangingEntity_setDirection = null;
        try {
            tmp_handle_LivingEntity_getDeathSound = LOOKUP.unreflect(LivingEntity_getDeathSound);
            tmp_handle_HangingEntity_setDirection = LOOKUP.unreflect(HangingEntity_setDirection);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        handle_LivingEntity_getDeathSound = tmp_handle_LivingEntity_getDeathSound;
        handle_HangingEntity_setDirection = tmp_handle_HangingEntity_setDirection;
    }
}

