/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.util;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import org.jetbrains.annotations.Nullable;
import twilightforest.world.components.structures.TFStructureComponentTemplate;
import twilightforest.world.components.structures.util.DecorationClearance;

public abstract class LandmarkStructure
extends Structure
implements DecorationClearance {
    protected final DecorationClearance.DecorationConfig decorationConfig;

    protected static <S extends LandmarkStructure> Products.P2<RecordCodecBuilder.Mu<S>, DecorationClearance.DecorationConfig, Structure.StructureSettings> landmarkCodec(RecordCodecBuilder.Instance<S> instance) {
        return instance.group((App)DecorationClearance.DecorationConfig.FLAT_CODEC.forGetter(s -> s.decorationConfig), (App)Structure.m_226567_(instance));
    }

    public LandmarkStructure(DecorationClearance.DecorationConfig decorationConfig, Structure.StructureSettings structureSettings) {
        super(structureSettings);
        this.decorationConfig = decorationConfig;
    }

    private static Structure.GenerationStub getStructurePieceGenerationStubFunction(StructurePiece startingPiece, Structure.GenerationContext context, int x, int y, int z) {
        return new Structure.GenerationStub(new BlockPos(x, y, z), structurePiecesBuilder -> {
            structurePiecesBuilder.m_142679_(startingPiece);
            startingPiece.m_214092_(startingPiece, (StructurePieceAccessor)structurePiecesBuilder, (RandomSource)context.f_226626_());
            structurePiecesBuilder.f_192778_.stream().filter(TFStructureComponentTemplate.class::isInstance).map(TFStructureComponentTemplate.class::cast).forEach(t -> t.LAZY_TEMPLATE_LOADER.run());
        });
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        boolean dontCenter = this.dontCenter();
        int x = (chunkPos.f_45578_ << 4) + (dontCenter ? 0 : 7);
        int z = (chunkPos.f_45579_ << 4) + (dontCenter ? 0 : 7);
        int y = this.adjustForTerrain(context, x, z);
        return Optional.ofNullable(this.getFirstPiece(context, RandomSource.m_216335_((long)(context.f_226627_() + (long)chunkPos.f_45578_ * 25117L + (long)chunkPos.f_45579_ * 151121L)), chunkPos, x, y, z)).map(piece -> LandmarkStructure.getStructurePieceGenerationStubFunction(piece, context, x, y, z));
    }

    @Deprecated
    protected boolean dontCenter() {
        return false;
    }

    @Nullable
    protected abstract StructurePiece getFirstPiece(Structure.GenerationContext var1, RandomSource var2, ChunkPos var3, int var4, int var5, int var6);

    @Override
    public boolean isSurfaceDecorationsAllowed() {
        return this.decorationConfig.surfaceDecorations();
    }

    @Override
    public boolean isUndergroundDecoAllowed() {
        return this.decorationConfig.undergroundDecorations();
    }

    @Override
    public boolean shouldAdjustToTerrain() {
        return this.decorationConfig.adjustElevation();
    }

    @Override
    public int chunkClearanceRadius() {
        return this.decorationConfig.chunkClearanceRadius();
    }
}

